/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.renderer;

import java.awt.Color;
import java.awt.Font;
import java.io.Serializable;
import javax.swing.event.EventListenerList;
import org.jfree.chart3d.ChartElementVisitor;
import org.jfree.chart3d.internal.Args;
import org.jfree.chart3d.label.ItemLabelPositioning;
import org.jfree.chart3d.renderer.Renderer3D;
import org.jfree.chart3d.renderer.Renderer3DChangeEvent;
import org.jfree.chart3d.renderer.Renderer3DChangeListener;

public abstract class AbstractRenderer3D
implements Renderer3D,
Serializable {
    private Font itemLabelFont = new Font("Serif", 0, 12);
    private Color itemLabelColor = Color.WHITE;
    private Color itemLabelBackgroundColor = new Color(100, 100, 100, 100);
    private ItemLabelPositioning itemLabelPositioning = ItemLabelPositioning.CENTRAL;
    private final transient EventListenerList listenerList = new EventListenerList();
    private boolean notify = true;

    protected AbstractRenderer3D() {
    }

    public Font getItemLabelFont() {
        return this.itemLabelFont;
    }

    public void setItemLabelFont(Font itemLabelFont) {
        Args.nullNotPermitted(itemLabelFont, "itemLabelFont");
        this.itemLabelFont = itemLabelFont;
        this.fireChangeEvent(true);
    }

    public Color getItemLabelColor() {
        return this.itemLabelColor;
    }

    public void setItemLabelColor(Color itemLabelColor) {
        Args.nullNotPermitted(itemLabelColor, "itemLabelColor");
        this.itemLabelColor = itemLabelColor;
        this.fireChangeEvent(true);
    }

    public Color getItemLabelBackgroundColor() {
        return this.itemLabelBackgroundColor;
    }

    public void setItemLabelBackgroundColor(Color color) {
        Args.nullNotPermitted(color, "color");
        this.itemLabelBackgroundColor = color;
        this.fireChangeEvent(true);
    }

    public ItemLabelPositioning getItemLabelPositioning() {
        return this.itemLabelPositioning;
    }

    public void setItemLabelPositioning(ItemLabelPositioning positioning) {
        Args.nullNotPermitted((Object)positioning, "positioning");
        this.itemLabelPositioning = positioning;
        this.fireChangeEvent(true);
    }

    public boolean isNotify() {
        return this.notify;
    }

    public void setNotify(boolean notify) {
        this.notify = notify;
        if (notify) {
            this.fireChangeEvent(true);
        }
    }

    @Override
    public void receive(ChartElementVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void addChangeListener(Renderer3DChangeListener listener) {
        this.listenerList.add(Renderer3DChangeListener.class, listener);
    }

    @Override
    public void removeChangeListener(Renderer3DChangeListener listener) {
        this.listenerList.remove(Renderer3DChangeListener.class, listener);
    }

    public void notifyListeners(Renderer3DChangeEvent event) {
        if (!this.notify) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != Renderer3DChangeListener.class) continue;
            ((Renderer3DChangeListener)listeners[i + 1]).rendererChanged(event);
        }
    }

    protected void fireChangeEvent(boolean requiresWorldUpdate) {
        this.notifyListeners(new Renderer3DChangeEvent(this, requiresWorldUpdate));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractRenderer3D)) {
            return false;
        }
        AbstractRenderer3D that = (AbstractRenderer3D)obj;
        if (this.notify != that.notify) {
            return false;
        }
        if (!this.itemLabelFont.equals(that.itemLabelFont)) {
            return false;
        }
        if (!this.itemLabelColor.equals(that.itemLabelColor)) {
            return false;
        }
        if (!this.itemLabelBackgroundColor.equals(that.itemLabelBackgroundColor)) {
            return false;
        }
        return this.itemLabelPositioning == that.itemLabelPositioning;
    }
}

