/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.renderer;

import java.awt.Color;
import org.jfree.chart3d.data.Range;
import org.jfree.chart3d.internal.Args;
import org.jfree.chart3d.renderer.AbstractColorScale;
import org.jfree.chart3d.renderer.ColorScale;

public class GradientColorScale
extends AbstractColorScale
implements ColorScale {
    private final Color lowColor;
    private final Color highColor;
    private final Color[] colors;

    public GradientColorScale(Range range, Color lowColor, Color highColor) {
        super(range);
        Args.nullNotPermitted(lowColor, "lowColor");
        Args.nullNotPermitted(highColor, "highColor");
        this.lowColor = lowColor;
        this.highColor = highColor;
        this.colors = new Color[255];
    }

    public Color getLowColor() {
        return this.lowColor;
    }

    public Color getHighColor() {
        return this.highColor;
    }

    public int getSampleCount() {
        return this.colors.length;
    }

    @Override
    public Color valueToColor(double value) {
        Range r = this.getRange();
        if (value < r.getMin()) {
            return this.valueToColor(r.getMin());
        }
        if (value > r.getMax()) {
            return this.valueToColor(r.getMax());
        }
        double fraction = this.getRange().percent(value);
        int i = Math.min((int)(fraction * (double)this.colors.length), this.colors.length - 1);
        if (this.colors[i] == null) {
            float[] lrgba = this.lowColor.getRGBComponents(null);
            float[] hrgba = this.highColor.getRGBComponents(null);
            float p = (float)fraction;
            this.colors[i] = new Color(lrgba[0] * (1.0f - p) + hrgba[0] * p, lrgba[1] * (1.0f - p) + hrgba[1] * p, lrgba[2] * (1.0f - p) + hrgba[2] * p, lrgba[3] * (1.0f - p) + hrgba[3] * p);
        }
        return this.colors[i];
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GradientColorScale)) {
            return false;
        }
        GradientColorScale that = (GradientColorScale)obj;
        if (!this.lowColor.equals(that.lowColor)) {
            return false;
        }
        if (!this.highColor.equals(that.highColor)) {
            return false;
        }
        return super.equals(obj);
    }
}

