/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.renderer.category;

import java.awt.Color;
import java.io.Serializable;
import java.util.Arrays;
import org.jfree.chart3d.Colors;
import org.jfree.chart3d.internal.Args;
import org.jfree.chart3d.renderer.category.CategoryColorSource;

public class StandardCategoryColorSource
implements CategoryColorSource,
Serializable {
    private Color[] colors;

    public StandardCategoryColorSource() {
        this(Colors.getDefaultColors());
    }

    public StandardCategoryColorSource(Color ... colors) {
        Args.nullNotPermitted(colors, "colors");
        if (colors.length == 0) {
            throw new IllegalArgumentException("Zero length array not permitted.");
        }
        for (Color c : colors) {
            if (c != null) continue;
            throw new IllegalArgumentException("Null array entries not permitted.");
        }
        this.colors = (Color[])colors.clone();
    }

    @Override
    public Color getColor(int series, int row, int column) {
        return this.colors[series % this.colors.length];
    }

    @Override
    public Color getLegendColor(int series) {
        return this.colors[series % this.colors.length];
    }

    @Override
    public void style(Color ... colors) {
        Args.nullNotPermitted(colors, "colors");
        if (colors.length == 0) {
            throw new IllegalArgumentException("Zero length array not permitted.");
        }
        for (Color c : colors) {
            if (c != null) continue;
            throw new IllegalArgumentException("Null array entries not permitted.");
        }
        this.colors = (Color[])colors.clone();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StandardCategoryColorSource)) {
            return false;
        }
        StandardCategoryColorSource that = (StandardCategoryColorSource)obj;
        return Arrays.equals(this.colors, that.colors);
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Arrays.deepHashCode(this.colors);
        return hash;
    }
}

