/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.table;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jfree.chart3d.graphics2d.RefPt2D;
import org.jfree.chart3d.internal.Args;
import org.jfree.chart3d.internal.ObjectUtils;
import org.jfree.chart3d.table.RectanglePainter;
import org.jfree.chart3d.table.StandardRectanglePainter;

public abstract class AbstractTableElement
implements Serializable {
    private static final Color DEFAULT_BACKGROUND_COLOR = new Color(255, 255, 255, 127);
    private RefPt2D refPt = RefPt2D.CENTER;
    private Insets insets = new Insets(2, 2, 2, 2);
    private RectanglePainter background = new StandardRectanglePainter(DEFAULT_BACKGROUND_COLOR);
    private String tag = "";
    private final HashMap<String, Object> properties = new HashMap();

    public RefPt2D getRefPoint() {
        return this.refPt;
    }

    public void setRefPoint(RefPt2D refPt) {
        Args.nullNotPermitted((Object)refPt, "refPt");
        this.refPt = refPt;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void setInsets(Insets insets) {
        Args.nullNotPermitted(insets, "insets");
        this.insets = insets;
    }

    public RectanglePainter getBackground() {
        return this.background;
    }

    public void setBackground(RectanglePainter background) {
        this.background = background;
    }

    public void setBackgroundColor(Color color) {
        this.background = color != null ? new StandardRectanglePainter(color) : null;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        Args.nullNotPermitted(tag, "tag");
        this.tag = tag;
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public void setProperty(String key, Object value) {
        Args.nullNotPermitted(key, "key");
        this.properties.put(key, value);
    }

    public Dimension2D preferredSize(Graphics2D g2, Rectangle2D bounds) {
        return this.preferredSize(g2, bounds, null);
    }

    public abstract Dimension2D preferredSize(Graphics2D var1, Rectangle2D var2, Map<String, Object> var3);

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractTableElement)) {
            return false;
        }
        AbstractTableElement that = (AbstractTableElement)obj;
        if (!this.insets.equals(that.insets)) {
            return false;
        }
        return ObjectUtils.equals(this.background, that.background);
    }
}

