/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.table;

import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jfree.chart3d.graphics2d.Fit2D;
import org.jfree.chart3d.internal.Args;
import org.jfree.chart3d.table.AbstractTableElement;
import org.jfree.chart3d.table.ContainerElement;
import org.jfree.chart3d.table.ElementDimension;
import org.jfree.chart3d.table.ElementInfo;
import org.jfree.chart3d.table.HAlign;
import org.jfree.chart3d.table.TableElement;
import org.jfree.chart3d.table.TableElementOnDraw;
import org.jfree.chart3d.table.TableElementVisitor;

public class FlowElement
extends AbstractTableElement
implements ContainerElement,
Serializable {
    private List<TableElement> elements;
    private HAlign horizontalAlignment;
    private int hgap;

    public FlowElement() {
        this(HAlign.CENTER, 2);
    }

    public FlowElement(HAlign alignment, int hgap) {
        Args.nullNotPermitted((Object)alignment, "alignment");
        this.elements = new ArrayList<TableElement>();
        this.horizontalAlignment = alignment;
        this.hgap = hgap;
    }

    public int getHGap() {
        return this.hgap;
    }

    public void setHGap(int gap) {
        this.hgap = gap;
    }

    public HAlign getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(HAlign alignment) {
        Args.nullNotPermitted((Object)alignment, "alignment");
        this.horizontalAlignment = alignment;
    }

    public List<TableElement> getElements() {
        return new ArrayList<TableElement>(this.elements);
    }

    @Override
    public void addElement(TableElement element) {
        Args.nullNotPermitted(element, "element");
        this.elements.add(element);
    }

    @Override
    public void receive(TableElementVisitor visitor) {
        for (TableElement element : this.elements) {
            element.receive(visitor);
        }
    }

    private List<ElementInfo> rowOfElements(int first, Graphics2D g2, Rectangle2D bounds) {
        ArrayList<ElementInfo> result = new ArrayList<ElementInfo>();
        int index = first;
        boolean full = false;
        double w = this.getInsets().left + this.getInsets().right;
        while (index < this.elements.size() && !full) {
            TableElement element = this.elements.get(index);
            Dimension2D dim = element.preferredSize(g2, bounds);
            if (w + dim.getWidth() <= bounds.getWidth() || index == first) {
                result.add(new ElementInfo(element, dim));
                w += dim.getWidth() + (double)this.hgap;
                ++index;
                continue;
            }
            full = true;
        }
        return result;
    }

    private double calcRowHeight(List<ElementInfo> elementInfoList) {
        double result = 0.0;
        for (ElementInfo elementInfo : elementInfoList) {
            result = Math.max(result, elementInfo.getDimension().getHeight());
        }
        return result;
    }

    private double calcRowWidth(List<ElementInfo> elementInfoList, double hgap) {
        double result = 0.0;
        for (ElementInfo elementInfo : elementInfoList) {
            result += elementInfo.getDimension().getWidth();
        }
        int count = elementInfoList.size();
        if (count > 1) {
            result += (double)(count - 1) * hgap;
        }
        return result;
    }

    @Override
    public Dimension2D preferredSize(Graphics2D g2, Rectangle2D bounds, Map<String, Object> constraints) {
        List<ElementInfo> elementsInRow;
        Insets insets = this.getInsets();
        double width = insets.left + insets.right;
        double height = insets.top + insets.bottom;
        double maxRowWidth = 0.0;
        int elementCount = this.elements.size();
        for (int i = 0; i < elementCount; i += elementsInRow.size()) {
            elementsInRow = this.rowOfElements(i, g2, bounds);
            double rowHeight = this.calcRowHeight(elementsInRow);
            double rowWidth = this.calcRowWidth(elementsInRow, this.hgap);
            maxRowWidth = Math.max(rowWidth, maxRowWidth);
            height += rowHeight;
        }
        return new ElementDimension(width += maxRowWidth, height);
    }

    @Override
    public List<Rectangle2D> layoutElements(Graphics2D g2, Rectangle2D bounds, Map<String, Object> constraints) {
        int elementCount = this.elements.size();
        ArrayList<Rectangle2D> result = new ArrayList<Rectangle2D>(elementCount);
        int i = 0;
        double x = bounds.getX() + (double)this.getInsets().left;
        double y = bounds.getY() + (double)this.getInsets().top;
        while (i < elementCount) {
            List<ElementInfo> elementsInRow = this.rowOfElements(i, g2, bounds);
            double height = this.calcRowHeight(elementsInRow);
            double width = this.calcRowWidth(elementsInRow, this.hgap);
            if (this.horizontalAlignment == HAlign.CENTER) {
                x = bounds.getCenterX() - width / 2.0;
            } else if (this.horizontalAlignment == HAlign.RIGHT) {
                x = bounds.getMaxX() - (double)this.getInsets().right - width;
            }
            for (ElementInfo elementInfo : elementsInRow) {
                Dimension2D dim = elementInfo.getDimension();
                Rectangle2D.Double position = new Rectangle2D.Double(x, y, dim.getWidth(), height);
                result.add(position);
                x += ((RectangularShape)position).getWidth() + (double)this.hgap;
            }
            i += elementsInRow.size();
            x = bounds.getX() + (double)this.getInsets().left;
            y += height;
        }
        return result;
    }

    @Override
    public void draw(Graphics2D g2, Rectangle2D bounds) {
        this.draw(g2, bounds, null);
    }

    @Override
    public void draw(Graphics2D g2, Rectangle2D bounds, TableElementOnDraw onDrawHandler) {
        if (onDrawHandler != null) {
            onDrawHandler.beforeDraw(this, g2, bounds);
        }
        Shape savedClip = g2.getClip();
        g2.clip(bounds);
        Dimension2D prefDim = this.preferredSize(g2, bounds);
        Fit2D fitter = Fit2D.getNoScalingFitter(this.getRefPoint());
        Rectangle2D dest = fitter.fit(prefDim, bounds);
        List<Rectangle2D> layoutInfo = this.layoutElements(g2, dest, null);
        for (int i = 0; i < this.elements.size(); ++i) {
            Rectangle2D rect = layoutInfo.get(i);
            TableElement element = this.elements.get(i);
            element.draw(g2, rect, onDrawHandler);
        }
        g2.setClip(savedClip);
        if (onDrawHandler != null) {
            onDrawHandler.afterDraw(this, g2, bounds);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FlowElement)) {
            return false;
        }
        FlowElement that = (FlowElement)obj;
        if (this.hgap != that.hgap) {
            return false;
        }
        if (this.horizontalAlignment != that.horizontalAlignment) {
            return false;
        }
        if (!this.elements.equals(that.elements)) {
            return false;
        }
        return super.equals(obj);
    }
}

