/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart3d.table;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart3d.graphics2d.Anchor2D;
import org.jfree.chart3d.graphics2d.Fit2D;
import org.jfree.chart3d.graphics2d.Scale2D;
import org.jfree.chart3d.internal.Args;
import org.jfree.chart3d.internal.ObjectUtils;
import org.jfree.chart3d.internal.SerialUtils;
import org.jfree.chart3d.table.RectanglePainter;

public class StandardRectanglePainter
implements RectanglePainter,
Serializable {
    private transient Paint paint;
    private transient Image image;
    private Fit2D imageFit;

    public StandardRectanglePainter(Paint paint) {
        this(paint, null, null);
    }

    public StandardRectanglePainter(Paint paint, Image image, Fit2D imageFit) {
        Args.nullNotPermitted(paint, "paint");
        this.paint = paint;
        this.image = image;
        this.imageFit = new Fit2D(Anchor2D.TOP_CENTER, Scale2D.SCALE_BOTH);
        if (imageFit != null) {
            this.imageFit = imageFit;
        }
    }

    public Paint getPaint() {
        return this.paint;
    }

    public Image getImage() {
        return this.image;
    }

    public Fit2D getImageFit() {
        return this.imageFit;
    }

    @Override
    public void fill(Graphics2D g2, Rectangle2D bounds) {
        Paint saved = g2.getPaint();
        g2.setPaint(this.paint);
        g2.fill(bounds);
        if (this.image != null) {
            int w = this.image.getWidth(null);
            int h = this.image.getHeight(null);
            Rectangle2D imageBounds = this.imageFit.fit(new Dimension(w, h), bounds);
            g2.drawImage(this.image, (int)imageBounds.getX(), (int)imageBounds.getY(), (int)imageBounds.getWidth(), (int)imageBounds.getHeight(), null);
        }
        g2.setPaint(saved);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StandardRectanglePainter)) {
            return false;
        }
        StandardRectanglePainter that = (StandardRectanglePainter)obj;
        return ObjectUtils.equalsPaint(this.paint, that.paint);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        SerialUtils.writePaint(this.paint, stream);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.paint = SerialUtils.readPaint(stream);
    }
}

