/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.fx;

import java.awt.AWTException;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.ImageCapabilities;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.VolatileImage;
import org.jfree.fx.FXGraphicsDevice;

public class FXGraphicsConfiguration
extends GraphicsConfiguration {
    private GraphicsDevice device;
    private final int width;
    private final int height;
    private BufferedImage img;
    private GraphicsConfiguration gc;

    public FXGraphicsConfiguration(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public GraphicsDevice getDevice() {
        if (this.device == null) {
            this.device = new FXGraphicsDevice("FXGraphicsDevice", this);
        }
        return this.device;
    }

    @Override
    public ColorModel getColorModel() {
        return this.getColorModel(3);
    }

    @Override
    public ColorModel getColorModel(int transparency) {
        if (transparency == 3) {
            return ColorModel.getRGBdefault();
        }
        if (transparency == 1) {
            return new DirectColorModel(32, 0xFF0000, 65280, 255);
        }
        return null;
    }

    @Override
    public AffineTransform getDefaultTransform() {
        return new AffineTransform();
    }

    @Override
    public AffineTransform getNormalizingTransform() {
        return new AffineTransform();
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(this.width, this.height);
    }

    @Override
    public VolatileImage createCompatibleVolatileImage(int width, int height, ImageCapabilities caps, int transparency) throws AWTException {
        if (this.img == null) {
            this.img = new BufferedImage(1, 1, 2);
            this.gc = this.img.createGraphics().getDeviceConfiguration();
        }
        return this.gc.createCompatibleVolatileImage(width, height, caps, transparency);
    }
}

