/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.pdf.stream;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jfree.pdf.dictionary.Dictionary;
import org.jfree.pdf.filter.Filter;
import org.jfree.pdf.internal.PDFObject;
import org.jfree.pdf.util.Args;
import org.jfree.pdf.util.PDFUtils;

public abstract class Stream
extends PDFObject {
    private final List<Filter> filters = new ArrayList<Filter>();

    Stream(int number) {
        super(number);
    }

    public void addFilter(Filter f) {
        Args.nullNotPermitted(f, "f");
        this.filters.add(f);
    }

    public void removeFilters() {
        this.filters.clear();
    }

    @Override
    public byte[] getObjectBytes() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] streamData = this.getRawStreamData();
        for (Filter f : this.filters) {
            streamData = f.encode(streamData);
        }
        Dictionary dictionary = this.createDictionary(streamData.length);
        baos.write(dictionary.toPDFBytes());
        baos.write(PDFUtils.toBytes("stream\n"));
        baos.write(streamData);
        baos.write(PDFUtils.toBytes("endstream\n"));
        return baos.toByteArray();
    }

    protected Dictionary createDictionary(int streamLength) {
        Dictionary dictionary = new Dictionary();
        dictionary.put("/Length", streamLength);
        if (!this.filters.isEmpty()) {
            String[] decodes = new String[this.filters.size()];
            int count = this.filters.size();
            for (int i = 0; i < count; ++i) {
                Filter f = this.filters.get(count - i - 1);
                decodes[i] = f.getFilterType().getDecode();
            }
            dictionary.put("/Filter", decodes);
        }
        return dictionary;
    }

    public abstract byte[] getRawStreamData();
}

