/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.buildinfo;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.buildinfo.Config;
import org.jfrog.buildinfo.deployment.BuildInfoRecorder;
import org.jfrog.buildinfo.resolution.RepositoryListener;
import org.jfrog.buildinfo.resolution.ResolutionRepoHelper;
import org.jfrog.buildinfo.utils.Utils;

@Mojo(name="publish", defaultPhase=LifecyclePhase.VALIDATE, threadSafe=true)
public class ArtifactoryMojo
extends AbstractMojo {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static final String[] DEPLOY_GOALS = new String[]{"deploy", "maven-deploy-plugin"};
    @Parameter(required=true, defaultValue="${project}")
    MavenProject project;
    @Parameter(required=true, defaultValue="${session}")
    MavenSession session;
    @Component(role=RepositoryListener.class)
    RepositoryListener repositoryListener;
    @Parameter
    Config.Artifactory artifactory = new Config.Artifactory();
    @Parameter
    Map<String, String> deployProperties = new HashMap<String, String>();
    @Parameter
    Config.BuildInfo buildInfo = new Config.BuildInfo();
    @Parameter
    Config.Publisher publisher = new Config.Publisher();
    @Parameter
    Config.Resolver resolver = new Config.Resolver();

    public void execute() {
        if (this.session.getRequest().getData().putIfAbsent("configured", Boolean.TRUE) == null) {
            this.replaceVariables();
            this.enforceResolution();
            this.enforceDeployment();
        }
    }

    private void replaceVariables() {
        this.artifactory.delegate.getAllProperties().replaceAll((key, value) -> Utils.parseInput(value));
        this.deployProperties.replaceAll((key, value) -> Utils.parseInput(value));
    }

    private void enforceResolution() {
        ResolutionRepoHelper helper = new ResolutionRepoHelper(this.getLog(), this.session, this.artifactory.delegate);
        List<ArtifactRepository> resolutionRepositories = helper.getResolutionRepositories();
        if (CollectionUtils.isNotEmpty(resolutionRepositories)) {
            for (MavenProject mavenProject : this.session.getProjects()) {
                mavenProject.setPluginArtifactRepositories(resolutionRepositories);
                mavenProject.setRemoteArtifactRepositories(resolutionRepositories);
            }
        }
    }

    private void enforceDeployment() {
        if (!this.deployGoalExist()) {
            return;
        }
        this.skipDefaultDeploy();
        this.completeConfig();
        this.addDeployProperties();
        BuildInfoRecorder executionListener = new BuildInfoRecorder(this.session, this.getLog(), this.artifactory.delegate);
        this.repositoryListener.setBuildInfoRecorder(executionListener);
        this.session.getRequest().setExecutionListener((ExecutionListener)executionListener);
    }

    private boolean deployGoalExist() {
        return this.session.getGoals().stream().anyMatch(goal -> ArrayUtils.contains((Object[])DEPLOY_GOALS, (Object)goal));
    }

    private void skipDefaultDeploy() {
        this.session.getUserProperties().put("maven.deploy.skip", Boolean.TRUE.toString());
    }

    private void completeConfig() {
        ArtifactoryClientConfiguration.BuildInfoHandler buildInfo = this.buildInfo.delegate;
        buildInfo.setBuildTimestamp(Long.toString(this.session.getStartTime().getTime()));
        buildInfo.setBuildStarted(DATE_FORMAT.format(this.session.getStartTime()));
        if (StringUtils.isBlank((CharSequence)buildInfo.getBuildName())) {
            buildInfo.setBuildName(this.project.getArtifactId());
        }
        if (StringUtils.isBlank((CharSequence)buildInfo.getBuildNumber())) {
            buildInfo.setBuildNumber(buildInfo.getBuildTimestamp());
        }
        buildInfo.setBuildAgentName("Maven");
        buildInfo.setBuildAgentVersion(Utils.getMavenVersion(((Object)((Object)this)).getClass()));
        if (buildInfo.getBuildRetentionDays() != null) {
            buildInfo.setBuildRetentionMinimumDate(buildInfo.getBuildRetentionDays().toString());
        }
    }

    private void addDeployProperties() {
        final ArtifactoryClientConfiguration.BuildInfoHandler buildInfo = this.buildInfo.delegate;
        Properties deployProperties = new Properties(){
            {
                ArtifactoryMojo.this.addDeployProperty(this, "build.timestamp", buildInfo.getBuildTimestamp());
                ArtifactoryMojo.this.addDeployProperty(this, "build.name", buildInfo.getBuildName());
                ArtifactoryMojo.this.addDeployProperty(this, "build.number", buildInfo.getBuildNumber());
            }
        };
        this.deployProperties.forEach((key, value) -> this.addDeployProperty(deployProperties, (String)key, (String)value));
        this.artifactory.delegate.fillFromProperties(deployProperties);
    }

    private void addDeployProperty(Properties deployProperties, String key, String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            deployProperties.put("artifactory.deploy." + key, value);
        }
    }
}

