/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.buildinfo.deployment;

import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.maven.plugin.logging.Log;
import org.jfrog.build.api.Artifact;
import org.jfrog.build.api.BaseBuildFileBean;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.Module;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;
import org.jfrog.build.extractor.ModuleParallelDeployHelper;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryManagerBuilder;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployDetails;
import org.jfrog.build.extractor.retention.Utils;
import org.jfrog.buildinfo.utils.ArtifactoryMavenLogger;

public class BuildDeployer {
    private static final String LOG_PREFIX = "Artifactory Build info recorder: ";
    private final Log logger;

    public BuildDeployer(Log logger) {
        this.logger = logger;
    }

    public void deploy(Build build, ArtifactoryClientConfiguration clientConf, Map<String, DeployDetails> deployableArtifacts) {
        Map<String, Set<DeployDetails>> deployableArtifactsByModule = this.prepareDeployableArtifacts(build.getModules(), deployableArtifacts);
        boolean isDeployArtifacts = this.isDeployArtifacts(clientConf, deployableArtifactsByModule);
        boolean isPublishBuildInfo = this.isPublishBuildInfo(clientConf);
        if (!isDeployArtifacts && !isPublishBuildInfo) {
            return;
        }
        try (ArtifactoryManager client = ((ArtifactoryManagerBuilder)((ArtifactoryManagerBuilder)new ArtifactoryManagerBuilder().setClientConfiguration(clientConf, (ArtifactoryClientConfiguration.RepositoryConfiguration)clientConf.publisher)).setLog((org.jfrog.build.api.util.Log)new ArtifactoryMavenLogger(this.logger))).build();){
            if (clientConf.getInsecureTls()) {
                client.setInsecureTls(true);
            }
            if (isDeployArtifacts) {
                this.logger.debug((CharSequence)("Artifactory Build info recorder: Publication fork count: " + clientConf.publisher.getPublishForkCount()));
                new ModuleParallelDeployHelper().deployArtifacts(client, deployableArtifactsByModule, clientConf.publisher.getPublishForkCount().intValue());
            }
            if (isPublishBuildInfo) {
                this.logger.info((CharSequence)"Artifactory Build info recorder: Deploying build info ...");
                Utils.sendBuildAndBuildRetention((ArtifactoryManager)client, (Build)build, (ArtifactoryClientConfiguration)clientConf);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Artifactory Build info recorder: Failed to deploy build info.", e);
        }
    }

    private boolean isDeployArtifacts(ArtifactoryClientConfiguration clientConf, Map<String, Set<DeployDetails>> deployableArtifacts) {
        if (!clientConf.publisher.isPublishArtifacts().booleanValue()) {
            this.logger.info((CharSequence)"Artifactory Build info recorder: deploy artifacts set to false, artifacts will not be deployed...");
            return false;
        }
        if (MapUtils.isEmpty(deployableArtifacts)) {
            this.logger.info((CharSequence)"Artifactory Build info recorder: no artifacts to deploy...");
            return false;
        }
        return true;
    }

    private boolean isPublishBuildInfo(ArtifactoryClientConfiguration clientConf) {
        if (!clientConf.publisher.isPublishBuildInfo().booleanValue()) {
            this.logger.info((CharSequence)"Artifactory Build info recorder: publish build info set to false, build info will not be published...");
            return false;
        }
        return true;
    }

    private Map<String, Set<DeployDetails>> prepareDeployableArtifacts(List<Module> modules, Map<String, DeployDetails> deployableArtifacts) {
        LinkedHashMap<String, Set<DeployDetails>> deployableArtifactsByModule = new LinkedHashMap<String, Set<DeployDetails>>();
        for (Module module : modules) {
            LinkedHashSet<DeployDetails> moduleDeployableArtifacts = new LinkedHashSet<DeployDetails>();
            for (Artifact moduleArtifact : ListUtils.emptyIfNull((List)module.getArtifacts())) {
                String artifactId = BuildInfoExtractorUtils.getArtifactId((String)module.getId(), (String)moduleArtifact.getName());
                DeployDetails deployableArtifact = deployableArtifacts.get(artifactId);
                if (deployableArtifact == null) continue;
                moduleDeployableArtifacts.add(this.createDeployDetails(deployableArtifact, moduleArtifact));
            }
            if (moduleDeployableArtifacts.isEmpty()) continue;
            deployableArtifactsByModule.put(module.getId(), moduleDeployableArtifacts);
        }
        return deployableArtifactsByModule;
    }

    private DeployDetails createDeployDetails(DeployDetails deployableArtifact, Artifact artifact) {
        org.jfrog.buildinfo.utils.Utils.setChecksums(deployableArtifact.getFile(), (BaseBuildFileBean)artifact, this.logger);
        return new DeployDetails.Builder().artifactPath(deployableArtifact.getArtifactPath()).file(deployableArtifact.getFile()).md5(artifact.getMd5()).sha1(artifact.getSha1()).addProperties((Multimap)deployableArtifact.getProperties()).targetRepository(deployableArtifact.getTargetRepository()).packageType(DeployDetails.PackageType.MAVEN).build();
    }
}

