/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.buildinfo.deployment;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.jfrog.build.api.Agent;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.BuildAgent;
import org.jfrog.build.api.MatrixParameter;
import org.jfrog.build.api.Vcs;
import org.jfrog.build.api.builder.BuildInfoMavenBuilder;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.util.GitUtils;
import org.jfrog.buildinfo.utils.ArtifactoryMavenLogger;
import org.jfrog.buildinfo.utils.Utils;

public class BuildInfoModelPropertyResolver
extends BuildInfoMavenBuilder {
    private final Log logger;

    public BuildInfoModelPropertyResolver(Log logger, MavenSession session, ArtifactoryClientConfiguration clientConf) {
        super((String)StringUtils.firstNonBlank((CharSequence[])new String[]{clientConf.info.getBuildName(), session.getTopLevelProject().getName()}));
        this.logger = logger;
        this.resolveCoreProperties(session, clientConf);
        this.resolveProperties(clientConf);
        this.resolveBuildAgent(clientConf);
        this.addRunParameters(clientConf);
        this.extractVcs(session);
    }

    private void resolveCoreProperties(MavenSession session, ArtifactoryClientConfiguration clientConf) {
        String buildNumber = (String)StringUtils.defaultIfBlank((CharSequence)clientConf.info.getBuildNumber(), (CharSequence)Long.toString(System.currentTimeMillis()));
        this.number(buildNumber);
        long buildStartTime = session.getRequest().getStartTime().getTime();
        String buildStarted = (String)StringUtils.defaultIfBlank((CharSequence)clientConf.info.getBuildStarted(), (CharSequence)Build.formatBuildStarted((long)buildStartTime));
        this.started(buildStarted);
        this.logResolvedProperty("build.name", this.name);
        this.logResolvedProperty("build.number", buildNumber);
        this.logResolvedProperty("build.started", buildStarted);
    }

    private void resolveProperties(ArtifactoryClientConfiguration clientConf) {
        this.artifactoryPluginVersion(clientConf.info.getArtifactoryPluginVersion());
        this.artifactoryPrincipal(clientConf.publisher.getName());
        this.parentNumber(clientConf.info.getParentBuildNumber());
        this.parentName(clientConf.info.getParentBuildName());
        this.principal(clientConf.info.getPrincipal());
        this.url(clientConf.info.getBuildUrl());
    }

    private void resolveBuildAgent(ArtifactoryClientConfiguration clientConf) {
        BuildAgent buildAgent = new BuildAgent("Maven", Utils.getMavenVersion(((Object)((Object)this)).getClass()));
        this.buildAgent(buildAgent);
        String agentName = clientConf.info.getAgentName();
        String agentVersion = clientConf.info.getAgentVersion();
        if (StringUtils.isBlank((CharSequence)agentName)) {
            agentName = "artifactory-maven-plugin";
            agentVersion = Utils.getPluginVersion();
        }
        this.agent(new Agent(agentName, agentVersion));
    }

    private void addRunParameters(ArtifactoryClientConfiguration clientConf) {
        clientConf.info.getRunParameters().entrySet().stream().map(param -> new MatrixParameter((String)param.getKey(), (String)param.getValue())).forEach(arg_0 -> ((BuildInfoModelPropertyResolver)this).addRunParameters(arg_0));
    }

    private void extractVcs(MavenSession session) {
        try {
            this.vcs(Lists.newArrayList((Object[])new Vcs[]{GitUtils.extractVcs((File)session.getCurrentProject().getBasedir(), (org.jfrog.build.api.util.Log)new ArtifactoryMavenLogger(this.logger))}));
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't extract VCS information: " + ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
    }

    private void logResolvedProperty(String key, String value) {
        this.logger.debug((CharSequence)("Artifactory Build Info Model Property Resolver: " + key + " = " + value));
    }
}

