/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.buildinfo.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.Maven;
import org.apache.maven.plugin.logging.Log;
import org.jfrog.build.api.BaseBuildFileBean;
import org.jfrog.build.api.util.FileChecksumCalculator;
import org.jfrog.buildinfo.ArtifactoryMojo;

public class Utils {
    public static void setChecksums(File file, BaseBuildFileBean buildFile, Log logger) {
        if (!Utils.isFile(file)) {
            return;
        }
        try {
            Map checksumsMap = FileChecksumCalculator.calculateChecksums((File)file, (String[])new String[]{"md5", "sha1"});
            buildFile.setMd5((String)checksumsMap.get("md5"));
            buildFile.setSha1((String)checksumsMap.get("sha1"));
        }
        catch (IOException | NoSuchAlgorithmException e) {
            logger.error((CharSequence)("Could not set checksum values on '" + buildFile.getLocalPath() + "': " + e.getMessage()), (Throwable)e);
        }
    }

    public static String getMavenVersion(Class currentClass) {
        Throwable throwable;
        InputStream inputStream;
        Properties mavenVersionProperties = new Properties();
        try {
            inputStream = currentClass.getClassLoader().getResourceAsStream("org/apache/maven/messages/build.properties");
            throwable = null;
            try {
                if (inputStream != null) {
                    mavenVersionProperties.load(inputStream);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inputStream != null) {
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error while extracting Maven version properties from: org/apache/maven/messages/build.properties", e);
        }
        if (mavenVersionProperties.isEmpty()) {
            try {
                inputStream = Maven.class.getClassLoader().getResourceAsStream("META-INF/maven/org.apache.maven/maven-core/pom.properties");
                throwable = null;
                try {
                    if (inputStream != null) {
                        mavenVersionProperties.load(inputStream);
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (inputStream != null) {
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            inputStream.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error while extracting Maven version properties from: META-INF/maven/org.apache.maven/maven-core/pom.properties", e);
            }
        }
        if (mavenVersionProperties.isEmpty()) {
            throw new RuntimeException("Could not extract Maven version: unable to find resources 'org/apache/maven/messages/build.properties' or 'META-INF/maven/org.apache.maven/maven-core/pom.properties'");
        }
        String version = mavenVersionProperties.getProperty("version");
        if (StringUtils.isBlank((CharSequence)version)) {
            throw new RuntimeException("Could not extract Maven version: no version property found in the resource 'org/apache/maven/messages/build.properties' or or 'META-INF/maven/org.apache.maven/maven-core/pom.properties'");
        }
        return version;
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public static String getPluginVersion() {
        block30: {
            try {
                Throwable throwable = null;
                try (InputStream inputStream = ArtifactoryMojo.class.getClassLoader().getResourceAsStream("META-INF/maven/org.jfrog.buildinfo/artifactory-maven-plugin/plugin-help.xml");){
                    if (inputStream != null) {
                        try (Stream<String> lines = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines();){
                            String version = lines.filter(line -> line.contains("<version>")).findFirst().orElse("");
                            String string = StringUtils.substringBetween((String)version, (String)"<version>", (String)"</version>");
                            return string;
                        }
                    }
                    break block30;
                    {
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throw throwable3;
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getArtifactName(String artifactId, String version, String classifier, String fileExtension) {
        String name = artifactId + "-" + version;
        if (StringUtils.isNotBlank((CharSequence)classifier)) {
            name = name + "-" + classifier;
        }
        return name + "." + fileExtension;
    }

    public static String getDeploymentPath(String groupId, String artifactId, String version, String classifier, String fileExtension) {
        return String.join((CharSequence)"/", groupId.replace(".", "/"), artifactId, version, Utils.getArtifactName(artifactId, version, classifier, fileExtension));
    }

    public static String getFileExtension(File file) {
        if (file == null) {
            return "";
        }
        return FilenameUtils.getExtension((String)file.getName());
    }

    public static boolean isFile(File file) {
        return file != null && file.isFile();
    }

    public static String parseInput(String input) {
        StringBuilder result = new StringBuilder();
        while (StringUtils.isNotBlank((CharSequence)input)) {
            String beforeBrackets = StringUtils.substringBefore((String)input, (String)"{{");
            result.append(beforeBrackets);
            if (!StringUtils.startsWith((CharSequence)(input = StringUtils.removeStart((String)input, (String)beforeBrackets)), (CharSequence)"{{")) continue;
            result.append(Utils.parseCurlyBrackets(input));
            input = StringUtils.substringAfter((String)input, (String)"}}");
        }
        return result.toString();
    }

    private static String parseCurlyBrackets(String input) {
        String unboxed = StringUtils.substringBetween((String)input, (String)"{{", (String)"}}");
        if (unboxed == null) {
            throw new IllegalArgumentException("Illegal input '" + input + "'. Missing '}}'.");
        }
        Object[] tokens = StringUtils.split((String)unboxed, (String)"|");
        if (ArrayUtils.isEmpty((Object[])tokens)) {
            return "";
        }
        Object lastValue = tokens[tokens.length - 1];
        String defaultValue = StringUtils.substringBetween((String)lastValue, (String)"\"");
        int lastNotDefault = defaultValue == null ? tokens.length - 1 : tokens.length - 2;
        for (int i = 0; i <= lastNotDefault; ++i) {
            Object currentToken = tokens[i];
            String variableValue = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{System.getenv((String)currentToken), System.getProperty((String)currentToken)});
            if (variableValue == null) continue;
            return variableValue;
        }
        return StringUtils.defaultString((String)defaultValue);
    }
}

