/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.buildinfo.resolution;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.DefaultArtifact;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.aether.AbstractRepositoryListener;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.jfrog.buildinfo.deployment.BuildInfoRecorder;

@Named
@Singleton
public class RepositoryListener
extends AbstractRepositoryListener {
    private BuildInfoRecorder buildInfoRecorder;
    @Inject
    private Logger logger;

    public RepositoryListener() {
    }

    public RepositoryListener(Logger logger) {
        this.logger = logger;
    }

    public void setBuildInfoRecorder(BuildInfoRecorder buildInfoRecorder) {
        this.buildInfoRecorder = buildInfoRecorder;
    }

    public void artifactResolved(RepositoryEvent event) {
        if (this.buildInfoRecorder == null) {
            return;
        }
        String requestContext = ((ArtifactRequest)event.getTrace().getData()).getRequestContext();
        String scope = this.getScopeByRequestContext(requestContext);
        org.apache.maven.artifact.Artifact artifact = this.toMavenArtifact(event.getArtifact(), scope);
        if (artifact == null) {
            return;
        }
        if (event.getRepository() != null) {
            this.logger.debug("[buildinfo] Resolved artifact: " + artifact + " from: " + event.getRepository() + ". Context is: " + requestContext);
            this.buildInfoRecorder.artifactResolved(artifact);
            return;
        }
        this.logger.debug("[buildinfo] Could not resolve artifact: " + artifact);
    }

    private org.apache.maven.artifact.Artifact toMavenArtifact(Artifact art, String scope) {
        if (art == null) {
            return null;
        }
        String classifier = StringUtils.defaultString((String)art.getClassifier());
        DefaultArtifact artifact = new DefaultArtifact(art.getGroupId(), art.getArtifactId(), art.getVersion(), scope, art.getExtension(), classifier, null);
        artifact.setFile(art.getFile());
        return artifact;
    }

    private String getScopeByRequestContext(String requestContext) {
        return StringUtils.equals((CharSequence)requestContext, (CharSequence)"plugin") ? "build" : "project";
    }
}

