/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.buildinfo.resolution;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.Authentication;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.buildinfo.utils.ArtifactoryMavenLogger;

public class ResolutionRepoHelper {
    private final ArtifactoryClientConfiguration clientConfiguration;
    private final Log logger;

    public ResolutionRepoHelper(Log logger, final MavenSession session, ArtifactoryClientConfiguration clientConfiguration) {
        this.logger = logger;
        this.clientConfiguration = clientConfiguration;
        Properties allMavenProps = new Properties(){
            {
                this.putAll((Map<?, ?>)session.getSystemProperties());
                this.putAll((Map<?, ?>)session.getUserProperties());
            }
        };
        Properties allProps = BuildInfoExtractorUtils.mergePropertiesWithSystemAndPropertyFile((Properties)allMavenProps, (org.jfrog.build.api.util.Log)new ArtifactoryMavenLogger(logger));
        this.clientConfiguration.fillFromProperties(allProps);
    }

    public List<ArtifactRepository> getResolutionRepositories() {
        Authentication authentication;
        ArrayList resolutionRepositories = Lists.newArrayList();
        String snapshotRepoUrl = this.getRepoSnapshotUrl();
        String releaseRepoUrl = this.getRepoReleaseUrl();
        String username = this.getRepoUsername();
        Authentication authentication2 = authentication = StringUtils.isNotBlank((CharSequence)username) ? new Authentication(username, this.getRepoPassword()) : null;
        if (StringUtils.isNotBlank((CharSequence)snapshotRepoUrl)) {
            resolutionRepositories.add(this.createSnapshotsRepository(snapshotRepoUrl, authentication));
        }
        if (StringUtils.isNotBlank((CharSequence)releaseRepoUrl)) {
            resolutionRepositories.add(this.createReleasesRepository(releaseRepoUrl, authentication, resolutionRepositories.isEmpty()));
        }
        return resolutionRepositories;
    }

    private ArtifactRepository createSnapshotsRepository(String repoUrl, Authentication authentication) {
        this.logger.debug((CharSequence)("[buildinfo] Enforcing snapshot repository for resolution: " + repoUrl));
        ArtifactRepositoryPolicy releasePolicy = new ArtifactRepositoryPolicy(false, "daily", "warn");
        ArtifactRepositoryPolicy snapshotPolicy = new ArtifactRepositoryPolicy(true, "daily", "warn");
        MavenArtifactRepository snapshotRepository = new MavenArtifactRepository("artifactory-snapshot", repoUrl, (ArtifactRepositoryLayout)new DefaultRepositoryLayout(), snapshotPolicy, releasePolicy);
        if (authentication != null) {
            this.logger.debug((CharSequence)("[buildinfo] Enforcing repository authentication: " + authentication + " for snapshot resolution repository"));
            snapshotRepository.setAuthentication(authentication);
        }
        return snapshotRepository;
    }

    private ArtifactRepository createReleasesRepository(String repoUrl, Authentication authentication, boolean snapshotPolicyEnabled) {
        this.logger.debug((CharSequence)("[buildinfo] Enforcing release repository for resolution: " + repoUrl));
        String repositoryId = snapshotPolicyEnabled ? "artifactory-release-snapshot" : "artifactory-release";
        ArtifactRepositoryPolicy releasePolicy = new ArtifactRepositoryPolicy(true, "daily", "warn");
        ArtifactRepositoryPolicy snapshotPolicy = new ArtifactRepositoryPolicy(snapshotPolicyEnabled, "daily", "warn");
        MavenArtifactRepository releasePluginRepository = new MavenArtifactRepository(repositoryId, repoUrl, (ArtifactRepositoryLayout)new DefaultRepositoryLayout(), snapshotPolicy, releasePolicy);
        if (authentication != null) {
            this.logger.debug((CharSequence)("[buildinfo] Enforcing repository authentication: " + authentication + " for release resolution repository"));
            releasePluginRepository.setAuthentication(authentication);
        }
        return releasePluginRepository;
    }

    private String getRepoReleaseUrl() {
        return this.clientConfiguration.resolver.getUrl(this.clientConfiguration.resolver.getRepoKey());
    }

    private String getRepoSnapshotUrl() {
        return this.clientConfiguration.resolver.getUrl(this.clientConfiguration.resolver.getDownloadSnapshotRepoKey());
    }

    private String getRepoUsername() {
        return this.clientConfiguration.resolver.getUsername();
    }

    private String getRepoPassword() {
        return this.clientConfiguration.resolver.getPassword();
    }
}

