/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.client;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.BuildFileBean;

public class DeployDetails {
    private String targetRepository;
    String artifactPath;
    File file;
    String sha1;
    String md5;
    Map<String, String> properties;

    public String getTargetRepository() {
        return this.targetRepository;
    }

    public String getArtifactPath() {
        return this.artifactPath;
    }

    public File getFile() {
        return this.file;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public String getSha1() {
        return this.sha1;
    }

    public String getMd5() {
        return this.md5;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeployDetails details = (DeployDetails)o;
        return this.artifactPath.equals(details.artifactPath);
    }

    public int hashCode() {
        return this.artifactPath.hashCode();
    }

    public static class Builder {
        private DeployDetails deployDetails = new DeployDetails();

        public DeployDetails build() {
            if (this.deployDetails.file == null || !this.deployDetails.file.exists()) {
                throw new IllegalArgumentException("File not found: " + this.deployDetails.file);
            }
            if (StringUtils.isBlank((String)this.deployDetails.targetRepository)) {
                throw new IllegalArgumentException("Target repository cannot be empty");
            }
            if (StringUtils.isBlank((String)this.deployDetails.artifactPath)) {
                throw new IllegalArgumentException("Artifact path cannot be empty");
            }
            return this.deployDetails;
        }

        public Builder bean(BuildFileBean bean) {
            Properties beanProperties = bean.getProperties();
            if (beanProperties != null) {
                this.deployDetails.properties = Maps.fromProperties((Properties)beanProperties);
            }
            this.deployDetails.sha1 = bean.getSha1();
            this.deployDetails.md5 = bean.getMd5();
            return this;
        }

        public Builder file(File file) {
            this.deployDetails.file = file;
            return this;
        }

        public Builder targetRepository(String targetRepository) {
            this.deployDetails.targetRepository = targetRepository;
            return this;
        }

        public Builder artifactPath(String artifactPath) {
            this.deployDetails.artifactPath = artifactPath;
            return this;
        }

        public Builder sha1(String sha1) {
            this.deployDetails.sha1 = sha1;
            return this;
        }

        public Builder md5(String md5) {
            this.deployDetails.md5 = md5;
            return this;
        }

        public Builder addProperty(String key, String value) {
            if (this.deployDetails.properties == null) {
                this.deployDetails.properties = new HashMap<String, String>();
            }
            this.deployDetails.properties.put(key, value);
            return this;
        }

        public Builder addProperties(Map<String, String> propertiesToAdd) {
            if (this.deployDetails.properties == null) {
                this.deployDetails.properties = new HashMap<String, String>();
            }
            this.deployDetails.properties.putAll(propertiesToAdd);
            return this;
        }
    }
}

