/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.go.extractor;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.Dependency;
import org.jfrog.build.api.Module;
import org.jfrog.build.api.builder.DependencyBuilder;
import org.jfrog.build.api.builder.ModuleBuilder;
import org.jfrog.build.api.builder.ModuleType;
import org.jfrog.build.api.util.FileChecksumCalculator;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryManagerBuilder;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.build.extractor.executor.CommandResults;
import org.jfrog.build.extractor.go.GoDriver;
import org.jfrog.build.extractor.go.extractor.GoCommand;
import org.jfrog.build.extractor.packageManager.PackageManagerUtils;

public class GoRun
extends GoCommand {
    private static final String GO_ENV_CMD = "env";
    private static final String GOPATH_ENV_VAR = "GOPATH";
    private static final String GOPROXY_ENV_VAR = "GOPROXY";
    private static final String GO_GET_GOPATH_CMD = "env GOPATH";
    private static final String GOPROXY_VCS_FALLBACK = "direct";
    private static final String CACHE_INNER_PATH = Paths.get("pkg", "mod", "cache", "download").toString();
    private static final String ARTIFACTORY_GO_API = "/api/go/";
    private static final String LOCAL_GO_SUM_FILENAME = "go.sum";
    private static final String LOCAL_GO_SUM_BACKUP_FILENAME = "jfrog.go.sum.backup";
    private static final String LOCAL_GO_MOD_BACKUP_FILENAME = "jfrog.go.mod.backup";
    private List<Dependency> dependenciesList = new ArrayList<Dependency>();
    private String goCmdArgs;
    private String resolutionRepository;
    private String resolverUsername;
    private String resolverPassword;
    private Map<String, String> env;

    public GoRun(String goCmdArgs, Path path, String buildInfoModuleId, ArtifactoryManagerBuilder artifactoryManagerBuilder, String repo, String username, String password, Log logger, Map<String, String> env) {
        super(artifactoryManagerBuilder, path, buildInfoModuleId, logger);
        this.env = env;
        this.goCmdArgs = goCmdArgs;
        this.resolutionRepository = repo;
        this.resolverUsername = username;
        this.resolverPassword = password;
    }

    public static void main(String[] ignored) {
        try {
            ArtifactoryClientConfiguration clientConfiguration = PackageManagerUtils.createArtifactoryClientConfiguration();
            ArtifactoryManagerBuilder artifactoryManagerBuilder = (ArtifactoryManagerBuilder)new ArtifactoryManagerBuilder().setClientConfiguration(clientConfiguration, (ArtifactoryClientConfiguration.RepositoryConfiguration)clientConfiguration.resolver);
            ArtifactoryClientConfiguration.PackageManagerHandler packageManagerHandler = clientConfiguration.packageManagerHandler;
            ArtifactoryClientConfiguration.GoHandler goHandler = clientConfiguration.goHandler;
            GoRun goRun = new GoRun(packageManagerHandler.getArgs(), Paths.get(packageManagerHandler.getPath() != null ? packageManagerHandler.getPath() : ".", new String[0]), packageManagerHandler.getModule(), artifactoryManagerBuilder, clientConfiguration.resolver.getRepoKey(), clientConfiguration.resolver.getUsername(), clientConfiguration.resolver.getPassword(), clientConfiguration.getLog(), clientConfiguration.getAllProperties());
            goRun.executeAndSaveBuildInfo(clientConfiguration);
        }
        catch (RuntimeException e) {
            ExceptionUtils.printRootCauseStackTrace((Throwable)e, (PrintStream)System.out);
            System.exit(1);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Build execute() {
        try (ArtifactoryManager artifactoryClient = this.artifactoryManagerBuilder != null ? this.artifactoryManagerBuilder.build() : null;){
            if (artifactoryClient != null) {
                this.preparePrerequisites(this.resolutionRepository, artifactoryClient);
                this.setResolverAsGoProxy(artifactoryClient);
            }
            this.goDriver = new GoDriver("go", this.env, this.path.toFile(), this.logger);
            this.goDriver.version(true);
            this.goDriver.runCmd(this.goCmdArgs, true);
            this.moduleName = this.goDriver.getModuleName();
            this.collectDependencies();
            Build build = this.createBuild();
            return build;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void setResolverAsGoProxy(ArtifactoryManager artifactoryClient) throws Exception {
        String rtUrl = PackageManagerUtils.createArtifactoryUrlWithCredentials((String)artifactoryClient.getUrl(), (String)this.resolverUsername, (String)this.resolverPassword, (String)(ARTIFACTORY_GO_API + this.resolutionRepository));
        String proxyValue = rtUrl + "," + GOPROXY_VCS_FALLBACK;
        this.env.put(GOPROXY_ENV_VAR, proxyValue);
    }

    private void collectDependencies() throws Exception {
        String[] dependenciesGraph;
        this.backupModAnsSumFiles();
        CommandResults goGraphResult = this.goDriver.modGraph(true);
        String cachePath = this.getCachePath();
        for (String entry : dependenciesGraph = goGraphResult.getRes().split("\\r?\\n")) {
            String moduleToAdd = entry.split(" ")[1];
            this.addModuleDependencies(moduleToAdd, cachePath);
        }
        this.restoreModAnsSumFiles();
    }

    private void backupModAnsSumFiles() throws IOException {
        this.createBackupFile(this.path, "go.mod", LOCAL_GO_MOD_BACKUP_FILENAME);
        this.createBackupFile(this.path, LOCAL_GO_SUM_FILENAME, LOCAL_GO_SUM_BACKUP_FILENAME);
    }

    private void restoreModAnsSumFiles() throws IOException {
        this.restoreFile(this.path, "go.mod", LOCAL_GO_MOD_BACKUP_FILENAME);
        this.restoreFile(this.path, LOCAL_GO_SUM_FILENAME, LOCAL_GO_SUM_BACKUP_FILENAME);
    }

    private void createBackupFile(Path parentPath, String sourceFilename, String backupFilename) throws IOException {
        File source = new File(this.path.toString() + File.separator + sourceFilename);
        File backup = new File(this.path.toString() + File.separator + backupFilename);
        Files.copy(source.toPath(), backup.toPath(), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
    }

    private void restoreFile(Path parentPath, String sourceFilename, String backupFilename) throws IOException {
        File source = new File(this.path.toString() + File.separator + sourceFilename);
        File backup = new File(this.path.toString() + File.separator + backupFilename);
        Files.move(backup.toPath(), source.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    private String getCachePath() throws Exception {
        CommandResults goEnvResult = this.goDriver.runCmd(GO_GET_GOPATH_CMD, true);
        return goEnvResult.getRes().trim() + File.separator + CACHE_INNER_PATH + File.separator;
    }

    private String convertModuleNameToCachePathConvention(String moduleName) {
        String upperCaseSign = "!";
        for (int i = 0; i < moduleName.length(); ++i) {
            if (!Character.isUpperCase(moduleName.charAt(i))) continue;
            moduleName = moduleName.replace(moduleName.substring(i, i + 1), upperCaseSign + Character.toLowerCase(moduleName.charAt(i)));
            i += upperCaseSign.length();
        }
        return moduleName;
    }

    private void addModuleDependencies(String module, String cachePath) throws Exception {
        String moduleName = module.split("@")[0];
        String moduleVersion = module.split("@")[1];
        String cachedPkgPath = cachePath + this.convertModuleNameToCachePathConvention(moduleName) + File.separator + "@v" + File.separator + moduleVersion + ".zip";
        File moduleZip = new File(cachedPkgPath);
        if (moduleZip.exists()) {
            Map checksums = FileChecksumCalculator.calculateChecksums((File)moduleZip, (String[])new String[]{"MD5", "SHA1"});
            Dependency dependency = new DependencyBuilder().id(moduleName + ':' + moduleVersion).md5((String)checksums.get("MD5")).sha1((String)checksums.get("SHA1")).type("zip").build();
            this.dependenciesList.add(dependency);
        }
    }

    private Build createBuild() {
        Build build = new Build();
        String moduleId = (String)StringUtils.defaultIfBlank((CharSequence)this.buildInfoModuleId, (CharSequence)this.moduleName);
        Module module = new ModuleBuilder().type(ModuleType.GO).id(moduleId).dependencies(this.dependenciesList).build();
        build.setModules(Collections.singletonList(module));
        return build;
    }
}

