/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.go.extractor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.tree.MutableTreeNode;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.executor.CommandResults;
import org.jfrog.build.extractor.go.GoDriver;
import org.jfrog.build.extractor.scan.DependencyTree;

public class GoDependencyTree {
    public static DependencyTree createDependencyTree(GoDriver goDriver, Log logger, boolean verbose) throws IOException {
        CommandResults usedModulesResults;
        CommandResults goGraphResult = goDriver.modGraph(verbose);
        String[] dependenciesGraph = goGraphResult.getRes().split("\\r?\\n");
        try {
            usedModulesResults = goDriver.getUsedModules(false, false);
        }
        catch (IOException e) {
            usedModulesResults = goDriver.getUsedModules(false, true);
            logger.warn("Errors occurred during building the Go dependency tree. The dependency tree may be incomplete:" + System.lineSeparator() + ExceptionUtils.getRootCauseMessage((Throwable)e));
        }
        Set<String> usedDependencies = Arrays.stream(usedModulesResults.getRes().split("\\r?\\n")).map(String::trim).map(usedModule -> usedModule.replace(" ", "@")).collect(Collectors.toSet());
        String rootPackageName = goDriver.getModuleName();
        DependencyTree rootNode = new DependencyTree((Object)rootPackageName);
        rootNode.setMetadata(true);
        HashMap<String, List<String>> dependenciesMap = new HashMap<String, List<String>>();
        GoDependencyTree.populateDependenciesMap(dependenciesGraph, usedDependencies, dependenciesMap);
        GoDependencyTree.populateDependencyTree(rootNode, rootPackageName, dependenciesMap, logger);
        return rootNode;
    }

    private static void populateDependenciesMap(String[] dependenciesGraph, Set<String> usedDependencies, Map<String, List<String>> dependenciesMap) {
        for (String entry : dependenciesGraph) {
            String[] parsedEntry;
            if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{entry}) || !usedDependencies.contains((parsedEntry = entry.split("\\s"))[1])) continue;
            List pkgDeps = dependenciesMap.computeIfAbsent(parsedEntry[0], k -> new ArrayList());
            pkgDeps.add(parsedEntry[1]);
        }
    }

    private static void populateDependencyTree(DependencyTree currNode, String currNameVersionString, Map<String, List<String>> allDependencies, Log logger) {
        if (currNode.hasLoop(logger)) {
            return;
        }
        List<String> currDependencies = allDependencies.get(currNameVersionString);
        if (currDependencies == null) {
            return;
        }
        for (String dependency : currDependencies) {
            String[] dependencyNameVersion = dependency.split("@v");
            DependencyTree DependencyTree2 = new DependencyTree((Object)(dependencyNameVersion[0] + ":" + dependencyNameVersion[1]));
            currNode.add((MutableTreeNode)DependencyTree2);
            GoDependencyTree.populateDependencyTree(DependencyTree2, dependency, allDependencies, logger);
        }
    }
}

