/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.go.extractor;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jfrog.build.api.util.Log;

public class GoVersionUtils {
    public static final String INCOMPATIBLE = "+incompatible";
    public static final int ZERO_OR_ONE = 0;
    protected static final Pattern VERSION_PATTERN = Pattern.compile("v(\\d*)\\.(\\d+)\\.(\\d+)");

    public static int getMajorVersion(String version, Log log) {
        String major;
        if (StringUtils.isEmpty((CharSequence)version)) {
            return 0;
        }
        Matcher matcher = VERSION_PATTERN.matcher(version = GoVersionUtils.getCleanVersion(version));
        if (matcher.matches() && !StringUtils.isEmpty((CharSequence)(major = matcher.group(1)))) {
            try {
                return Integer.parseInt(major);
            }
            catch (NumberFormatException e) {
                log.error("Failed to parse major version of " + version, (Throwable)e);
            }
        }
        return 0;
    }

    public static int getMajorProjectVersion(String project, Log log) {
        if (!StringUtils.isEmpty((CharSequence)project) && (project = project.toLowerCase()).matches("^.*/v\\d+")) {
            String major = project.substring(project.lastIndexOf("/v") + 2);
            try {
                return Integer.parseInt(major);
            }
            catch (NumberFormatException e) {
                log.error("Failed to parse major version of " + project, (Throwable)e);
            }
        }
        return 0;
    }

    public static String getCleanVersion(String version) {
        if (!StringUtils.isEmpty((CharSequence)version) && version.contains(INCOMPATIBLE)) {
            version = version.substring(0, version.indexOf(INCOMPATIBLE));
        }
        return version;
    }

    public static boolean isCompatibleGoModuleNaming(String projectName, String version, Log log) {
        if (StringUtils.isBlank((CharSequence)projectName) || StringUtils.isBlank((CharSequence)version)) {
            return false;
        }
        int majorVersion = GoVersionUtils.getMajorVersion(version, log);
        if (majorVersion >= 2) {
            return projectName.endsWith("/v" + majorVersion) && !version.endsWith(INCOMPATIBLE);
        }
        return majorVersion == 1 || majorVersion == 0;
    }

    public static String getSubModule(String projectName) {
        if (StringUtils.isBlank((CharSequence)projectName)) {
            return "";
        }
        String[] parts = projectName.split("/", 4);
        if (parts.length >= 4) {
            return parts[3];
        }
        return "";
    }

    public static String getParent(String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            return "";
        }
        String parentPath = new File(path).getParent();
        if (StringUtils.isNotEmpty((CharSequence)parentPath)) {
            return parentPath.replace('\\', '/');
        }
        return "";
    }
}

