/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.task;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.TaskAction;
import org.jfrog.build.api.release.Distribution;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.client.ArtifactoryBuildInfoClient;
import org.jfrog.gradle.plugin.artifactory.dsl.ArtifactoryPluginConvention;
import org.jfrog.gradle.plugin.artifactory.dsl.DistributerConfig;
import org.jfrog.gradle.plugin.artifactory.extractor.GradleClientLogger;

public class DistributeBuildTask
extends DefaultTask {
    public static final String DISTRIBUTE_TASK_NAME = "artifactoryDistributeBuild";
    private static final Logger log = Logging.getLogger(DistributeBuildTask.class);

    @TaskAction
    public void distributeBuild() throws IOException {
        this.validate();
        ArtifactoryPluginConvention convention = (ArtifactoryPluginConvention)this.getProject().getConvention().getPlugins().get("artifactory");
        DistributerConfig distributerConfig = convention.getDistributerConfig();
        ArtifactoryClientConfiguration clientConf = convention.getClientConfig();
        String buildName = distributerConfig.getBuildName();
        String buildNumber = distributerConfig.getBuildNumber();
        buildName = buildName == null ? clientConf.info.getBuildName() : buildName;
        buildNumber = buildNumber == null ? clientConf.info.getBuildNumber() : buildNumber;
        Distribution distribution = new Distribution(distributerConfig.getPublish(), distributerConfig.getOverrideExistingFiles(), distributerConfig.getGpgPassphrase(), distributerConfig.getAsync(), distributerConfig.getTargetRepoKey(), new ArrayList<String>(distributerConfig.getSourceRepoKeys()), distributerConfig.getDryRun());
        try (ArtifactoryBuildInfoClient client = new ArtifactoryBuildInfoClient(distributerConfig.getContextUrl(), distributerConfig.getUsername(), distributerConfig.getPassword(), (Log)new GradleClientLogger(this.getLogger()));
             CloseableHttpResponse response = client.distributeBuild(buildName, buildNumber, distribution);){
            String content = response.getEntity() != null ? EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8") : "";
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            StatusLine status = response.getStatusLine();
            if (status.getStatusCode() != 200) {
                throw new IOException(String.format("Distribution failed. Received '%s', '%s' from Artifactory.", status.getReasonPhrase(), content));
            }
            log.info(String.format("Successfully distributed build %s/%s", clientConf.info.getBuildName(), clientConf.info.getBuildNumber()));
        }
    }

    private void validate() {
        ArtifactoryPluginConvention convention = (ArtifactoryPluginConvention)this.getProject().getConvention().getPlugins().get("artifactory");
        DistributerConfig config = convention.getDistributerConfig();
        if (config == null) {
            throw new IllegalArgumentException("The build distribution configuration is missing.");
        }
        if (StringUtils.isEmpty((String)config.getContextUrl())) {
            throw new IllegalArgumentException("'contextUrl' is a mandatory field for build distribution.");
        }
        if (StringUtils.isEmpty((String)config.getTargetRepoKey())) {
            throw new IllegalArgumentException("'targetRepoKey' is a mandatory field for build distribution.");
        }
    }
}

