/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.task;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.TaskAction;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.IncludeExcludePatterns;
import org.jfrog.build.extractor.clientConfiguration.PatternMatcher;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployDetails;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployableArtifactsUtils;
import org.jfrog.build.extractor.retention.Utils;
import org.jfrog.gradle.plugin.artifactory.ArtifactoryPluginUtil;
import org.jfrog.gradle.plugin.artifactory.extractor.GradleArtifactoryClientConfigUpdater;
import org.jfrog.gradle.plugin.artifactory.extractor.GradleBuildInfoExtractor;
import org.jfrog.gradle.plugin.artifactory.extractor.GradleClientLogger;
import org.jfrog.gradle.plugin.artifactory.extractor.GradleDeployDetails;
import org.jfrog.gradle.plugin.artifactory.extractor.ModuleInfoFileProducer;
import org.jfrog.gradle.plugin.artifactory.task.ArtifactoryTask;

public class DeployTask
extends DefaultTask {
    private static final Logger log = Logging.getLogger(DeployTask.class);
    private List<ModuleInfoFileProducer> moduleInfoFileProducers = new ArrayList<ModuleInfoFileProducer>();

    @TaskAction
    public void taskAction() throws IOException {
        log.debug("Task '{}' activated", (Object)this.getPath());
        this.collectProjectBuildInfo();
    }

    private void collectProjectBuildInfo() throws IOException {
        File file;
        log.debug("Starting build info extraction for project '{}' using last task in graph '{}'", new Object[]{this.getProject().getPath(), this.getPath()});
        this.prepareAndDeploy();
        String propertyFilePath = System.getenv("buildInfoConfig.propertiesFile");
        if (StringUtils.isBlank((String)propertyFilePath)) {
            propertyFilePath = System.getenv("BUILDINFO_PROPFILE");
        }
        if (StringUtils.isNotBlank((String)propertyFilePath) && (file = new File(propertyFilePath)).exists()) {
            file.delete();
        }
    }

    private void prepareAndDeploy() throws IOException {
        ArtifactoryClientConfiguration accRoot = ArtifactoryPluginUtil.getArtifactoryConvention(this.getProject()).getClientConfig();
        Map propsRoot = accRoot.publisher.getProps();
        GradleArtifactoryClientConfigUpdater.setMissingBuildAttributes(accRoot, this.getProject().getRootProject());
        ConcurrentHashMap<String, Set<DeployDetails>> allDeployDetails = new ConcurrentHashMap<String, Set<DeployDetails>>();
        List<ArtifactoryTask> orderedTasks = this.findArtifactoryPublishTasks(this.getProject().getGradle().getTaskGraph());
        int publishForkCount = this.getPublishForkCount(accRoot);
        if (publishForkCount <= 1) {
            orderedTasks.forEach(t -> this.deployArtifacts(accRoot, propsRoot, (Map<String, Set<DeployDetails>>)allDeployDetails, (ArtifactoryTask)((Object)t), null));
        } else {
            try {
                ExecutorService executor = Executors.newFixedThreadPool(publishForkCount);
                CompletableFuture<Void> allUploads = CompletableFuture.allOf((CompletableFuture[])orderedTasks.stream().map(t -> CompletableFuture.runAsync(() -> this.deployArtifacts(accRoot, propsRoot, (Map<String, Set<DeployDetails>>)allDeployDetails, (ArtifactoryTask)((Object)t), "[" + Thread.currentThread().getName() + "]"), executor)).toArray(CompletableFuture[]::new));
                allUploads.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        GradleBuildInfoExtractor gbie = new GradleBuildInfoExtractor(accRoot, this.moduleInfoFileProducers);
        Build build = gbie.extract(this.getProject().getRootProject());
        this.exportBuildInfo(build, this.getExportFile(accRoot));
        this.generateBuildInfoJson(accRoot, build);
        this.handleBuildInfoDeployment(accRoot, build, allDeployDetails);
    }

    private void generateBuildInfoJson(ArtifactoryClientConfiguration accRoot, Build build) throws IOException {
        if (this.isGenerateBuildInfoToFile(accRoot).booleanValue()) {
            try {
                this.exportBuildInfo(build, new File(accRoot.info.getGeneratedBuildInfoFilePath()));
            }
            catch (Exception e) {
                log.error("Failed writing build info to file: ", (Throwable)e);
                throw new IOException("Failed writing build info to file", e);
            }
        }
    }

    private void handleBuildInfoDeployment(ArtifactoryClientConfiguration accRoot, Build build, Map<String, Set<DeployDetails>> allDeployDetails) throws IOException {
        block18: {
            String contextUrl = accRoot.publisher.getContextUrl();
            if (contextUrl != null) {
                try (ArtifactoryManager artifactoryManager = new ArtifactoryManager(accRoot.publisher.getContextUrl(), accRoot.publisher.getUsername(), accRoot.publisher.getPassword(), (Log)new GradleClientLogger(log));){
                    if (this.isPublishBuildInfo(accRoot).booleanValue()) {
                        this.exportBuildInfo(build, this.getExportFile(accRoot));
                        if (accRoot.info.isIncremental().booleanValue()) {
                            log.debug("Publishing build info modules to artifactory at: '{}'", (Object)contextUrl);
                            artifactoryManager.sendModuleInfo(build);
                        } else {
                            log.debug("Publishing build info to artifactory at: '{}'", (Object)contextUrl);
                            Utils.sendBuildAndBuildRetention((ArtifactoryManager)artifactoryManager, (Build)build, (ArtifactoryClientConfiguration)accRoot);
                        }
                    }
                    if (!this.isGenerateDeployableArtifactsToFile(accRoot).booleanValue()) break block18;
                    try {
                        this.exportDeployableArtifacts(allDeployDetails, new File(accRoot.info.getDeployableArtifactsFilePath()), accRoot.info.isBackwardCompatibleDeployableArtifacts());
                    }
                    catch (Exception e) {
                        log.error("Failed writing deployable artifacts to file: ", (Throwable)e);
                        throw new RuntimeException("Failed writing deployable artifacts to file", e);
                    }
                }
            }
        }
    }

    private void deployArtifacts(ArtifactoryClientConfiguration accRoot, Map<String, String> propsRoot, Map<String, Set<DeployDetails>> allDeployDetails, ArtifactoryTask artifactoryTask, String logPrefix) {
        block20: {
            try {
                if (artifactoryTask.getDidWork()) {
                    ArtifactoryClientConfiguration.PublisherHandler publisher = ArtifactoryPluginUtil.getPublisherHandler(artifactoryTask.getProject());
                    if (publisher == null || publisher.getContextUrl() == null) break block20;
                    HashMap<String, String> moduleProps = new HashMap<String, String>(propsRoot);
                    moduleProps.putAll(publisher.getProps());
                    publisher.getProps().putAll(moduleProps);
                    String contextUrl = publisher.getContextUrl();
                    String username = publisher.getUsername();
                    String password = publisher.getPassword();
                    if (StringUtils.isBlank((String)username)) {
                        username = "";
                    }
                    if (StringUtils.isBlank((String)password)) {
                        password = "";
                    }
                    if (publisher.isPublishArtifacts().booleanValue()) {
                        ArtifactoryManager artifactoryManager = new ArtifactoryManager(contextUrl, username, password, (Log)new GradleClientLogger(log));
                        Object object = null;
                        try {
                            log.debug("Uploading artifacts to Artifactory at '{}'", (Object)contextUrl);
                            IncludeExcludePatterns patterns = new IncludeExcludePatterns(publisher.getIncludePatterns(), publisher.getExcludePatterns());
                            this.configureProxy(accRoot, artifactoryManager);
                            this.configConnectionTimeout(accRoot, artifactoryManager);
                            this.configRetriesParams(accRoot, artifactoryManager);
                            this.deployArtifacts(artifactoryTask.deployDetails, artifactoryManager, patterns, logPrefix, publisher.getMinChecksumDeploySizeKb());
                        }
                        catch (Throwable patterns) {
                            object = patterns;
                            throw patterns;
                        }
                        finally {
                            if (artifactoryManager != null) {
                                if (object != null) {
                                    try {
                                        artifactoryManager.close();
                                    }
                                    catch (Throwable patterns) {
                                        ((Throwable)object).addSuppressed(patterns);
                                    }
                                } else {
                                    artifactoryManager.close();
                                }
                            }
                        }
                    }
                    if (!artifactoryTask.deployDetails.isEmpty()) {
                        LinkedHashSet<DeployDetails> deployDetailsSet = new LinkedHashSet<DeployDetails>();
                        for (GradleDeployDetails details : artifactoryTask.deployDetails) {
                            deployDetailsSet.add(details.getDeployDetails());
                        }
                        allDeployDetails.put(artifactoryTask.getProject().getName(), deployDetailsSet);
                    }
                    break block20;
                }
                log.debug("Task '{}' did no work", (Object)artifactoryTask.getPath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void configureProxy(ArtifactoryClientConfiguration clientConf, ArtifactoryManager artifactoryManager) {
        ArtifactoryClientConfiguration.ProxyHandler proxy = clientConf.proxy;
        String proxyHost = proxy.getHost();
        if (StringUtils.isNotBlank((String)proxyHost) && proxy.getPort() != null) {
            log.debug("Found proxy host '{}'", (Object)proxyHost);
            String proxyUserName = proxy.getUsername();
            if (StringUtils.isNotBlank((String)proxyUserName)) {
                log.debug("Found proxy user name '{}'", (Object)proxyUserName);
                artifactoryManager.setProxyConfiguration(proxyHost, proxy.getPort().intValue(), proxyUserName, proxy.getPassword());
            } else {
                log.debug("No proxy user name and password found, using anonymous proxy");
                artifactoryManager.setProxyConfiguration(proxyHost, proxy.getPort().intValue());
            }
        }
    }

    private void configConnectionTimeout(ArtifactoryClientConfiguration clientConf, ArtifactoryManager artifactoryManager) {
        if (clientConf.getTimeout() != null) {
            artifactoryManager.setConnectionTimeout(clientConf.getTimeout().intValue());
        }
    }

    private void configRetriesParams(ArtifactoryClientConfiguration clientConf, ArtifactoryManager artifactoryManager) {
        if (clientConf.getConnectionRetries() != null) {
            artifactoryManager.setConnectionRetries(clientConf.getConnectionRetries().intValue());
        }
    }

    private void exportBuildInfo(Build build, File toFile) throws IOException {
        log.debug("Exporting generated build info to '{}'", (Object)toFile.getAbsolutePath());
        BuildInfoExtractorUtils.saveBuildInfoToFile((Build)build, (File)toFile);
    }

    private void exportDeployableArtifacts(Map<String, Set<DeployDetails>> allDeployDetails, File toFile, boolean exportBackwardCompatibleDeployableArtifacts) throws IOException {
        log.debug("Exporting deployable artifacts to '{}'", (Object)toFile.getAbsolutePath());
        DeployableArtifactsUtils.saveDeployableArtifactsToFile(allDeployDetails, (File)toFile, (boolean)exportBackwardCompatibleDeployableArtifacts);
    }

    private File getExportFile(ArtifactoryClientConfiguration clientConf) {
        String fileExportPath = clientConf.getExportFile();
        if (StringUtils.isNotBlank((String)fileExportPath)) {
            return new File(fileExportPath);
        }
        Project rootProject = this.getProject().getRootProject();
        return new File(rootProject.getBuildDir(), "build-info.json");
    }

    @Nonnull
    private Boolean isPublishBuildInfo(ArtifactoryClientConfiguration acc) {
        return acc.publisher.isPublishBuildInfo();
    }

    private int getPublishForkCount(ArtifactoryClientConfiguration acc) {
        return acc.publisher.getPublishForkCount();
    }

    @Nonnull
    private Boolean isGenerateBuildInfoToFile(ArtifactoryClientConfiguration acc) {
        return !StringUtils.isEmpty((String)acc.info.getGeneratedBuildInfoFilePath());
    }

    @Nonnull
    private Boolean isGenerateDeployableArtifactsToFile(ArtifactoryClientConfiguration acc) {
        return !StringUtils.isEmpty((String)acc.info.getDeployableArtifactsFilePath());
    }

    private void deployArtifacts(Set<GradleDeployDetails> allDeployDetails, ArtifactoryManager artifactoryManager, IncludeExcludePatterns patterns, String logPrefix, int MinChecksumDeploySizeKb) throws IOException {
        for (GradleDeployDetails detail : allDeployDetails) {
            DeployDetails deployDetails = detail.getDeployDetails();
            String artifactPath = deployDetails.getArtifactPath();
            if (PatternMatcher.pathConflicts((String)artifactPath, (IncludeExcludePatterns)patterns)) {
                log.log(LogLevel.LIFECYCLE, "Skipping the deployment of '" + artifactPath + "' due to the defined include-exclude patterns.");
                continue;
            }
            artifactoryManager.upload(deployDetails, logPrefix, Integer.valueOf(MinChecksumDeploySizeKb));
        }
    }

    private List<ArtifactoryTask> findArtifactoryPublishTasks(TaskExecutionGraph graph) {
        ArrayList<ArtifactoryTask> tasks = new ArrayList<ArtifactoryTask>();
        for (Task task : graph.getAllTasks()) {
            if (!(task instanceof ArtifactoryTask)) continue;
            tasks.add((ArtifactoryTask)task);
        }
        return tasks;
    }

    @InputFiles
    public FileCollection getModuleInfoFiles() {
        ConfigurableFileCollection moduleInfoFiles = this.getProject().files(new Object[0]);
        this.moduleInfoFileProducers.forEach(moduleInfoFileProducer -> {
            moduleInfoFiles.from(new Object[]{moduleInfoFileProducer.getModuleInfoFiles()});
            moduleInfoFiles.builtBy(new Object[]{moduleInfoFileProducer.getModuleInfoFiles().getBuildDependencies()});
        });
        return moduleInfoFiles;
    }

    public void registerModuleInfoProducer(ModuleInfoFileProducer moduleInfoFileProducer) {
        this.moduleInfoFileProducers.add(moduleInfoFileProducer);
    }
}

