/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.task;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.GradleVersion;
import org.jfrog.build.api.Module;
import org.jfrog.build.extractor.ModuleExtractorUtils;
import org.jfrog.gradle.plugin.artifactory.extractor.GradleModuleExtractor;

public class ExtractModuleTask
extends DefaultTask {
    private final RegularFileProperty moduleFile;

    public ExtractModuleTask() {
        boolean gradleVersionOlderThanFiveZero = GradleVersion.current().compareTo(GradleVersion.version((String)"5.0")) < 0;
        this.moduleFile = gradleVersionOlderThanFiveZero ? (RegularFileProperty)this.invokeMethod(this.getProject().getLayout(), "fileProperty") : this.getProject().getObjects().fileProperty();
    }

    @OutputFile
    public RegularFileProperty getModuleFile() {
        return this.moduleFile;
    }

    @TaskAction
    void extractModuleFile() {
        Module module = new GradleModuleExtractor().extractModule(this.getProject());
        try {
            ModuleExtractorUtils.saveModuleToFile((Module)module, (File)((File)this.moduleFile.getAsFile().get()));
        }
        catch (IOException e) {
            throw new RuntimeException("Could not extract module file", e);
        }
    }

    <T> T invokeMethod(Object source, String methodName) {
        try {
            return (T)source.getClass().getMethod(methodName, new Class[0]).invoke(source, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

