/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.task.helper;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.apache.ivy.core.IvyPatternHelper;
import org.gradle.api.GradleException;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.PublicationContainer;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.internal.PublicationInternal;
import org.gradle.api.publish.ivy.IvyArtifact;
import org.gradle.api.publish.ivy.IvyPublication;
import org.gradle.api.publish.ivy.internal.publication.IvyPublicationInternal;
import org.gradle.api.publish.ivy.internal.publisher.IvyNormalizedPublication;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublicationIdentity;
import org.gradle.api.publish.maven.MavenArtifact;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.internal.publication.MavenPublicationInternal;
import org.gradle.api.publish.maven.internal.publisher.MavenNormalizedPublication;
import org.jfrog.build.api.util.FileChecksumCalculator;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployDetails;
import org.jfrog.gradle.plugin.artifactory.ArtifactoryPluginUtil;
import org.jfrog.gradle.plugin.artifactory.extractor.GradleDeployDetails;
import org.jfrog.gradle.plugin.artifactory.extractor.PublishArtifactInfo;
import org.jfrog.gradle.plugin.artifactory.task.ArtifactoryTask;
import org.jfrog.gradle.plugin.artifactory.task.helper.TaskHelper;

public class TaskHelperPublications
extends TaskHelper {
    public static final String MAVEN_JAVA = "mavenJava";
    public static final String MAVEN_WEB = "mavenWeb";
    public static final String IVY_JAVA = "ivyJava";
    public static final String ALL_PUBLICATIONS = "ALL_PUBLICATIONS";
    private static final Logger log = Logging.getLogger(TaskHelperPublications.class);
    private final Set<IvyPublication> ivyPublications;
    private final Set<MavenPublication> mavenPublications;
    private final Set<Object> publications = new HashSet<Object>();
    private boolean publishPublicationsSpecified;

    public TaskHelperPublications(ArtifactoryTask artifactoryTask) {
        super(artifactoryTask);
        this.ivyPublications = artifactoryTask.ivyPublications;
        this.mavenPublications = artifactoryTask.mavenPublications;
    }

    public void publications() {
        if (this.publications.size() == 0) {
            return;
        }
        for (Object publication : this.publications) {
            if (publication instanceof CharSequence) {
                PublicationContainer container = ((PublishingExtension)this.getProject().getExtensions().getByType(PublishingExtension.class)).getPublications();
                if (publication.toString().equals(ALL_PUBLICATIONS)) {
                    this.addAllPublications(container);
                    continue;
                }
                Publication publicationObj = (Publication)container.findByName(publication.toString());
                if (publicationObj != null) {
                    this.addPublication(publicationObj);
                    continue;
                }
                this.logPublicationNotFound(publication);
                continue;
            }
            if (publication instanceof Publication) {
                this.addPublication((Publication)publication);
                continue;
            }
            log.error("Publication type '{}' not supported in task '{}'.", (Object)publication.getClass().getName(), (Object)this.getPath());
        }
        this.publishPublicationsSpecified = true;
    }

    private void addAllPublications(PublicationContainer container) {
        container.forEach(this::addPublication);
    }

    @Override
    public void addCollection(Object ... publications) {
        Collections.addAll(this.publications, publications);
    }

    private void logPublicationNotFound(Object publication) {
        log.debug("Publication named '{}' does not exist for project '{}' in task '{}'.", new Object[]{publication, this.getProject().getPath(), this.getPath()});
    }

    public Set<IvyPublication> getIvyPublications() {
        return this.ivyPublications;
    }

    public Set<MavenPublication> getMavenPublications() {
        return this.mavenPublications;
    }

    public boolean hasPublications() {
        return !this.ivyPublications.isEmpty() || !this.mavenPublications.isEmpty();
    }

    public void checkDependsOnArtifactsToPublish() {
        String capitalizedPublicationName;
        this.publications();
        if (!this.hasPublications()) {
            return;
        }
        if (!this.hasPublications()) {
            if (this.publishPublicationsSpecified) {
                log.warn("None of the specified publications matched for project '{}' - nothing to publish.", (Object)this.getProject().getPath());
            } else {
                log.debug("No publications specified for project '{}'", (Object)this.getProject().getPath());
            }
            return;
        }
        for (IvyPublication ivyPublication : this.ivyPublications) {
            if (!(ivyPublication instanceof IvyPublicationInternal)) {
                log.warn("Ivy publication name '{}' is of unsupported type '{}'!", (Object)ivyPublication.getName(), ivyPublication.getClass());
                continue;
            }
            this.dependOn((Publication)ivyPublication);
            capitalizedPublicationName = ivyPublication.getName().substring(0, 1).toUpperCase() + ivyPublication.getName().substring(1);
            this.dependsOn(String.format("%s:generateDescriptorFileFor%sPublication", this.getProject().getPath(), capitalizedPublicationName));
        }
        for (MavenPublication mavenPublication : this.mavenPublications) {
            if (!(mavenPublication instanceof MavenPublicationInternal)) {
                log.warn("Maven publication name '{}' is of unsupported type '{}'!", (Object)mavenPublication.getName(), mavenPublication.getClass());
                continue;
            }
            this.dependOn((Publication)mavenPublication);
            capitalizedPublicationName = mavenPublication.getName().substring(0, 1).toUpperCase() + mavenPublication.getName().substring(1);
            this.dependsOn(String.format("%s:generatePomFileFor%sPublication", this.getProject().getPath(), capitalizedPublicationName));
        }
    }

    private void dependOn(Publication publication) {
        PublicationInternal publicationInternal = (PublicationInternal)publication;
        Object[] objectArray = new Object[1];
        objectArray[0] = () -> ((PublicationInternal)publicationInternal).getPublishableArtifacts();
        this.dependsOn(objectArray);
        publicationInternal.allPublishableArtifacts(xva$0 -> this.dependsOn(xva$0));
    }

    public void collectDescriptorsAndArtifactsForUpload() {
        Set<GradleDeployDetails> deployDetailsFromProject = this.getArtifactDeployDetails();
        this.artifactoryTask.deployDetails.addAll(deployDetailsFromProject);
    }

    public boolean hasModules() {
        return this.hasPublications();
    }

    public Set<GradleDeployDetails> getArtifactDeployDetails() {
        String publicationName;
        LinkedHashSet<GradleDeployDetails> deployDetails = new LinkedHashSet<GradleDeployDetails>();
        if (!this.hasPublications()) {
            log.info("No publications to publish for project '{}'.", (Object)this.getProject().getPath());
            return deployDetails;
        }
        for (IvyPublication ivyPublication : this.ivyPublications) {
            DeployDetails.Builder builder;
            publicationName = ivyPublication.getName();
            if (!(ivyPublication instanceof IvyPublicationInternal)) {
                log.warn("Ivy publication name '{}' is of unsupported type '{}'!", (Object)publicationName, ivyPublication.getClass());
                continue;
            }
            IvyPublicationInternal ivyPublicationInternal = (IvyPublicationInternal)ivyPublication;
            IvyNormalizedPublication ivyNormalizedPublication = ivyPublicationInternal.asNormalisedPublication();
            IvyPublicationIdentity projectIdentity = ivyNormalizedPublication.getProjectIdentity();
            Map extraInfo = ivyPublication.getDescriptor().getExtraInfo().asMap();
            File ivyFile = this.getIvyDescriptorFile(ivyNormalizedPublication);
            if (this.isPublishIvy().booleanValue() && (builder = this.createBuilder(ivyFile, publicationName)) != null) {
                PublishArtifactInfo artifactInfo = new PublishArtifactInfo(projectIdentity.getModule(), "xml", "ivy", null, extraInfo, ivyFile);
                this.addIvyArtifactToDeployDetails(deployDetails, publicationName, projectIdentity, builder, artifactInfo);
            }
            Set artifacts = ivyNormalizedPublication.getAllArtifacts();
            for (IvyArtifact artifact : artifacts) {
                DeployDetails.Builder builder2;
                File file = artifact.getFile();
                if (file.equals(ivyFile) || (builder2 = this.createBuilder(file, publicationName)) == null) continue;
                PublishArtifactInfo artifactInfo = new PublishArtifactInfo(artifact.getName(), artifact.getExtension(), artifact.getType(), artifact.getClassifier(), extraInfo, file);
                this.addIvyArtifactToDeployDetails(deployDetails, publicationName, projectIdentity, builder2, artifactInfo);
            }
        }
        for (MavenPublication mavenPublication : this.mavenPublications) {
            DeployDetails.Builder builder;
            publicationName = mavenPublication.getName();
            if (!(mavenPublication instanceof MavenPublicationInternal)) {
                log.warn("Maven publication name '{}' is of unsupported type '{}'!", (Object)publicationName, mavenPublication.getClass());
                continue;
            }
            MavenPublicationInternal mavenPublicationInternal = (MavenPublicationInternal)mavenPublication;
            MavenNormalizedPublication mavenNormalizedPublication = mavenPublicationInternal.asNormalisedPublication();
            File pomFile = mavenNormalizedPublication.getPomArtifact().getFile();
            if (this.isPublishMaven().booleanValue() && (builder = this.createBuilder(pomFile, publicationName)) != null) {
                PublishArtifactInfo artifactInfo = new PublishArtifactInfo(mavenPublication.getArtifactId(), "pom", "pom", null, pomFile);
                this.addMavenArtifactToDeployDetails(deployDetails, publicationName, builder, artifactInfo, mavenPublication);
            }
            boolean legacy = false;
            Set artifacts = new HashSet();
            try {
                artifacts = mavenNormalizedPublication.getAdditionalArtifacts();
                if (mavenNormalizedPublication.getMainArtifact() != null) {
                    this.createPublishArtifactInfoAndAddToDeployDetails(mavenNormalizedPublication.getMainArtifact(), deployDetails, mavenPublication, publicationName);
                }
            }
            catch (IllegalStateException exception) {
                log.warn("Illegal state detected at Maven publication '{}', {}: {}", new Object[]{publicationName, this.getProject(), exception.getMessage()});
            }
            catch (NoSuchMethodError error) {
                artifacts = mavenNormalizedPublication.getAllArtifacts();
                legacy = true;
            }
            for (MavenArtifact artifact : artifacts) {
                if (legacy && artifact.getFile().equals(pomFile)) continue;
                this.createPublishArtifactInfoAndAddToDeployDetails(artifact, deployDetails, mavenPublication, publicationName);
            }
        }
        return deployDetails;
    }

    public void addDefaultPublications() {
        if (!this.hasPublications()) {
            Publication ivyJavaPublication;
            Publication mavenWebPublication;
            if (this.publishPublicationsSpecified) {
                log.warn("None of the specified publications matched for project '{}' - nothing to publish.", (Object)this.getProject().getPath());
                return;
            }
            PublishingExtension publishingExtension = (PublishingExtension)this.getProject().getExtensions().findByName("publishing");
            if (publishingExtension == null) {
                log.warn("None of the specified publications matched for project '{}' - nothing to publish.", (Object)this.getProject().getPath());
                return;
            }
            Publication mavenJavaPublication = (Publication)publishingExtension.getPublications().findByName(MAVEN_JAVA);
            if (mavenJavaPublication != null) {
                log.info("No publications specified for project '{}' - adding '{}' publication.", (Object)this.getProject().getPath(), (Object)MAVEN_JAVA);
                this.addPublication(mavenJavaPublication);
            }
            if ((mavenWebPublication = (Publication)publishingExtension.getPublications().findByName(MAVEN_WEB)) != null) {
                log.info("No publications specified for project '{}' - adding '{}' publication.", (Object)this.getProject().getPath(), (Object)MAVEN_WEB);
                this.addPublication(mavenWebPublication);
            }
            if ((ivyJavaPublication = (Publication)publishingExtension.getPublications().findByName(IVY_JAVA)) != null) {
                log.info("No publications specified for project '{}' - adding '{}' publication.", (Object)this.getProject().getPath(), (Object)IVY_JAVA);
                this.addPublication(ivyJavaPublication);
            }
            this.checkDependsOnArtifactsToPublish();
        }
    }

    private void createPublishArtifactInfoAndAddToDeployDetails(MavenArtifact artifact, Set<GradleDeployDetails> deployDetails, MavenPublication mavenPublication, String publicationName) {
        File file = artifact.getFile();
        DeployDetails.Builder builder = this.createBuilder(file, publicationName);
        if (builder == null) {
            return;
        }
        PublishArtifactInfo artifactInfo = new PublishArtifactInfo(mavenPublication.getArtifactId(), artifact.getExtension(), artifact.getExtension(), artifact.getClassifier(), file);
        this.addMavenArtifactToDeployDetails(deployDetails, publicationName, builder, artifactInfo, mavenPublication);
    }

    private File getIvyDescriptorFile(IvyNormalizedPublication ivy) {
        try {
            return ivy.getIvyDescriptorFile();
        }
        catch (NoSuchMethodError error) {
            try {
                Method m = ivy.getClass().getMethod("getDescriptorFile", new Class[0]);
                return (File)m.invoke((Object)ivy, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void addPublication(Publication publicationObj) {
        if (publicationObj instanceof IvyPublication) {
            this.ivyPublications.add((IvyPublication)publicationObj);
        } else if (publicationObj instanceof MavenPublication) {
            this.mavenPublications.add((MavenPublication)publicationObj);
        } else {
            log.warn("Publication named '{}' in project '{}' is of unknown type '{}'", new Object[]{publicationObj.getName(), this.getProject().getPath(), publicationObj.getClass()});
        }
    }

    private DeployDetails.Builder createBuilder(File file, String publicationName) {
        if (!file.exists()) {
            throw new GradleException("File '" + file.getAbsolutePath() + "' does not exist, and need to be published from publication " + publicationName);
        }
        DeployDetails.Builder artifactBuilder = new DeployDetails.Builder().file(file).packageType(DeployDetails.PackageType.GRADLE);
        try {
            Map checksums = FileChecksumCalculator.calculateChecksums((File)file, (String[])new String[]{"MD5", "SHA1"});
            artifactBuilder.md5((String)checksums.get("MD5")).sha1((String)checksums.get("SHA1"));
        }
        catch (Exception e) {
            throw new GradleException("Failed to calculate checksums for artifact: " + file.getAbsolutePath(), (Throwable)e);
        }
        return artifactBuilder;
    }

    private Map<String, String> getExtraTokens(PublishArtifactInfo artifactInfo) {
        Map<QName, String> extraInfo;
        HashMap<String, String> extraTokens = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)artifactInfo.getClassifier())) {
            extraTokens.put("classifier", artifactInfo.getClassifier());
        }
        if ((extraInfo = artifactInfo.getExtraInfo()) != null) {
            for (Map.Entry<QName, String> extraToken : extraInfo.entrySet()) {
                String key = extraToken.getKey().getLocalPart();
                if (extraTokens.containsKey(key)) {
                    throw new GradleException("Duplicated extra info '" + key + "'.");
                }
                extraTokens.put(key, extraToken.getValue());
            }
        }
        return extraTokens;
    }

    private void addIvyArtifactToDeployDetails(Set<GradleDeployDetails> deployDetails, String publicationName, IvyPublicationIdentity projectIdentity, DeployDetails.Builder builder, PublishArtifactInfo artifactInfo) {
        ArtifactoryClientConfiguration.PublisherHandler publisher = ArtifactoryPluginUtil.getPublisherHandler(this.getProject());
        if (publisher == null) {
            return;
        }
        String pattern = "ivy".equals(artifactInfo.getType()) ? publisher.getIvyPattern() : publisher.getIvyArtifactPattern();
        String gid = projectIdentity.getOrganisation();
        if (publisher.isM2Compatible()) {
            gid = gid.replace(".", "/");
        }
        Map<String, String> extraTokens = this.getExtraTokens(artifactInfo);
        String artifactPath = IvyPatternHelper.substitute((String)pattern, (String)gid, (String)projectIdentity.getModule(), (String)projectIdentity.getRevision(), (String)artifactInfo.getName(), (String)artifactInfo.getType(), (String)artifactInfo.getExtension(), (String)publicationName, extraTokens, null);
        builder.artifactPath(artifactPath);
        this.addArtifactInfoToDeployDetails(deployDetails, publicationName, builder, artifactInfo, artifactPath);
    }

    private void addMavenArtifactToDeployDetails(Set<GradleDeployDetails> deployDetails, String publicationName, DeployDetails.Builder builder, PublishArtifactInfo artifactInfo, MavenPublication mavenPublication) {
        Map<String, String> extraTokens = this.getExtraTokens(artifactInfo);
        String artifactPath = IvyPatternHelper.substitute((String)"[organisation]/[module]/[revision]/[artifact]-[revision](-[classifier]).[ext]", (String)mavenPublication.getGroupId().replace(".", "/"), (String)mavenPublication.getArtifactId(), (String)mavenPublication.getVersion(), (String)artifactInfo.getName(), (String)artifactInfo.getType(), (String)artifactInfo.getExtension(), (String)publicationName, extraTokens, null);
        builder.artifactPath(artifactPath);
        this.addArtifactInfoToDeployDetails(deployDetails, publicationName, builder, artifactInfo, artifactPath);
    }

    private void addArtifactInfoToDeployDetails(Set<GradleDeployDetails> deployDetails, String publicationName, DeployDetails.Builder builder, PublishArtifactInfo artifactInfo, String artifactPath) {
        ArtifactoryClientConfiguration.PublisherHandler publisher = ArtifactoryPluginUtil.getPublisherHandler(this.getProject());
        if (publisher != null) {
            builder.targetRepository(this.getTargetRepository(artifactPath, publisher));
            Map<String, String> propsToAdd = this.getPropsToAdd(artifactInfo, publicationName);
            builder.addProperties(propsToAdd);
            DeployDetails details = builder.build();
            deployDetails.add(new GradleDeployDetails(artifactInfo, details, this.getProject()));
        }
    }
}

