/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.task.helper;

import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jfrog.build.extractor.clientConfiguration.ArtifactSpec;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.gradle.plugin.artifactory.ArtifactoryPluginUtil;
import org.jfrog.gradle.plugin.artifactory.extractor.PublishArtifactInfo;
import org.jfrog.gradle.plugin.artifactory.task.ArtifactoryTask;

public abstract class TaskHelper {
    private static final Logger log = Logging.getLogger(TaskHelper.class);
    protected ArtifactoryTask artifactoryTask;
    protected Map<String, String> defaultProps;

    public TaskHelper(ArtifactoryTask artifactoryTask) {
        this.artifactoryTask = artifactoryTask;
    }

    public Project getProject() {
        return this.artifactoryTask.getProject();
    }

    public Task dependsOn(Object ... paths) {
        return this.artifactoryTask.dependsOn(paths);
    }

    public String getPath() {
        return this.artifactoryTask.getPath();
    }

    public abstract void addCollection(Object ... var1);

    protected Map<String, String> getPropsToAdd(PublishArtifactInfo artifact, String publicationName) {
        Project project = this.getProject();
        if (this.defaultProps == null) {
            this.defaultProps = new HashMap<String, String>();
            this.addProps(this.defaultProps, this.artifactoryTask.getProperties());
            ArtifactoryClientConfiguration.PublisherHandler publisher = ArtifactoryPluginUtil.getPublisherHandler(project);
            if (publisher != null) {
                this.defaultProps.putAll((Map<String, String>)publisher.getMatrixParams());
            }
        }
        HashMap<String, String> propsToAdd = new HashMap<String, String>(this.defaultProps);
        ArtifactSpec spec = ArtifactSpec.builder().configuration(publicationName).group(project.getGroup().toString()).name(project.getName()).version(project.getVersion().toString()).classifier(artifact.getClassifier()).type(artifact.getType()).build();
        Multimap artifactSpecsProperties = this.artifactoryTask.artifactSpecs.getProperties(spec);
        this.addProps(propsToAdd, (Multimap<String, CharSequence>)artifactSpecsProperties);
        return propsToAdd;
    }

    private void addProps(Map<String, String> target, Multimap<String, CharSequence> props) {
        for (Map.Entry entry : props.entries()) {
            String key = (String)entry.getKey();
            String value = ((CharSequence)entry.getValue()).toString();
            if (!target.containsKey(key)) {
                target.put(key, value);
                continue;
            }
            value = target.get(key) + ", " + value;
            target.put(key, value);
        }
    }

    @Nonnull
    protected Boolean isPublishMaven() {
        ArtifactoryClientConfiguration.PublisherHandler publisher = ArtifactoryPluginUtil.getPublisherHandler(this.getProject());
        if (publisher == null) {
            return false;
        }
        Boolean publishPom = publisher.isMaven();
        if (publishPom == null) {
            publishPom = this.artifactoryTask.getPublishPom();
        }
        return publishPom != null ? publishPom : true;
    }

    @Nonnull
    protected Boolean isPublishIvy() {
        ArtifactoryClientConfiguration.PublisherHandler publisher = ArtifactoryPluginUtil.getPublisherHandler(this.getProject());
        if (publisher == null) {
            return false;
        }
        Boolean publishIvy = publisher.isIvy();
        if (publishIvy == null) {
            publishIvy = this.artifactoryTask.getPublishIvy();
        }
        return publishIvy != null ? publishIvy : true;
    }

    protected String getTargetRepository(String deployPath, ArtifactoryClientConfiguration.PublisherHandler publisher) {
        String snapshotsRepository = publisher.getSnapshotRepoKey();
        if (snapshotsRepository != null && deployPath.contains("-SNAPSHOT")) {
            return snapshotsRepository;
        }
        if (StringUtils.isNotEmpty((CharSequence)publisher.getReleaseRepoKey())) {
            return publisher.getReleaseRepoKey();
        }
        return publisher.getRepoKey();
    }
}

