/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.task;

import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.commons.collections4.MultiMapUtils;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.ivy.IvyPublication;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.ConfigureUtil;
import org.jfrog.build.extractor.clientConfiguration.ArtifactSpecs;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.gradle.plugin.artifactory.ArtifactoryPluginUtil;
import org.jfrog.gradle.plugin.artifactory.dsl.ArtifactoryPluginConvention;
import org.jfrog.gradle.plugin.artifactory.dsl.PropertiesConfig;
import org.jfrog.gradle.plugin.artifactory.dsl.PublisherConfig;
import org.jfrog.gradle.plugin.artifactory.extractor.GradleDeployDetails;
import org.jfrog.gradle.plugin.artifactory.task.helper.TaskHelperConfigurations;
import org.jfrog.gradle.plugin.artifactory.task.helper.TaskHelperPublications;

public class ArtifactoryTask
extends DefaultTask {
    public static final String DEPLOY_TASK_NAME = "artifactoryDeploy";
    public static final String ARTIFACTORY_PUBLISH_TASK_NAME = "artifactoryPublish";
    public static final String EXTRACT_MODULE_TASK_NAME = "extractModuleInfo";
    public static final String PUBLISH_ARTIFACTS = "publishArtifacts";
    public static final String PUBLISH_IVY = "publishIvy";
    public static final String PUBLISH_POM = "publishPom";
    private boolean evaluated = false;
    private static final Logger log = Logging.getLogger(ArtifactoryTask.class);
    private final Map<String, Boolean> flags = new HashMap<String, Boolean>();
    public File ivyDescriptor;
    public File mavenDescriptor;
    public Set<Configuration> publishConfigs = new HashSet<Configuration>();
    public Set<IvyPublication> ivyPublications = new HashSet<IvyPublication>();
    public Set<MavenPublication> mavenPublications = new HashSet<MavenPublication>();
    private boolean ciServerBuild = false;
    public TaskHelperConfigurations helperConfigurations = new TaskHelperConfigurations(this);
    public TaskHelperPublications helperPublications = new TaskHelperPublications(this);
    public final Set<GradleDeployDetails> deployDetails = new TreeSet<GradleDeployDetails>();
    private final MultiValuedMap<String, CharSequence> properties = MultiMapUtils.newListValuedHashMap();
    @Input
    public final ArtifactSpecs artifactSpecs = new ArtifactSpecs();
    @Input
    public boolean skip = false;

    @TaskAction
    public void taskAction() throws IOException {
        log.debug("Task '{}' activated", (Object)this.getPath());
    }

    private void checkDependsOnArtifactsToPublish() {
        this.helperConfigurations.checkDependsOnArtifactsToPublish();
        this.helperPublications.checkDependsOnArtifactsToPublish();
    }

    public void collectDescriptorsAndArtifactsForUpload() throws IOException {
        if (this.helperConfigurations.hasConfigurations()) {
            this.helperConfigurations.collectDescriptorsAndArtifactsForUpload();
        }
        if (this.helperPublications.hasPublications()) {
            this.helperPublications.collectDescriptorsAndArtifactsForUpload();
        }
    }

    public boolean hasModules() {
        return this.helperConfigurations.hasModules() || this.helperPublications.hasModules();
    }

    public boolean hasPublications() {
        return this.helperPublications.hasPublications();
    }

    public boolean hasConfigurations() {
        return this.helperConfigurations.hasConfigurations();
    }

    public void publishConfigs(Object ... confs) {
        if (confs != null) {
            this.helperConfigurations.addCollection(confs);
            this.checkDependsOnArtifactsToPublish();
        }
    }

    public void publications(Object ... publications) {
        if (publications != null) {
            this.helperPublications.addCollection(publications);
            this.checkDependsOnArtifactsToPublish();
        }
    }

    @Input
    Set<Publication> getPublications() {
        HashSet<Publication> publications = new HashSet<Publication>();
        publications.addAll(this.ivyPublications);
        publications.addAll(this.mavenPublications);
        return publications;
    }

    @InputFiles
    @Optional
    public Set<Configuration> getPublishConfigs() {
        return this.publishConfigs;
    }

    @Input
    @Optional
    public Set<IvyPublication> getIvyPublications() {
        return this.ivyPublications;
    }

    @Input
    @Optional
    public Set<MavenPublication> getMavenPublications() {
        return this.mavenPublications;
    }

    @InputFile
    @Optional
    public File getIvyDescriptor() {
        return this.ivyDescriptor;
    }

    @InputFile
    @Optional
    public File getMavenDescriptor() {
        return this.mavenDescriptor;
    }

    @Input
    public boolean isCiServerBuild() {
        return this.ciServerBuild;
    }

    public void setCiServerBuild() {
        this.ciServerBuild = true;
    }

    @Input
    public MultiValuedMap<String, CharSequence> getProperties() {
        return this.properties;
    }

    @Input
    @Optional
    @Nullable
    public Boolean getPublishArtifacts() {
        return this.getFlag(PUBLISH_ARTIFACTS);
    }

    @Input
    @Optional
    @Nullable
    public Boolean getPublishIvy() {
        return this.getFlag(PUBLISH_IVY);
    }

    @Input
    @Optional
    @Nullable
    public Boolean getPublishPom() {
        return this.getFlag(PUBLISH_POM);
    }

    public void projectEvaluated() {
        Project project = this.getProject();
        if (this.isSkip()) {
            log.debug("artifactoryPublish task '{}' skipped for project '{}'.", (Object)this.getPath(), (Object)project.getName());
        } else {
            ArtifactoryPluginConvention convention = ArtifactoryPluginUtil.getPublisherConvention(project);
            if (convention != null) {
                Action<ArtifactoryTask> defaultsAction;
                ArtifactoryClientConfiguration acc = convention.getClientConfig();
                this.artifactSpecs.clear();
                this.artifactSpecs.addAll((Collection)acc.publisher.getArtifactSpecs());
                PublisherConfig config = convention.getPublisherConfig();
                if (config != null && (defaultsAction = config.getDefaultsAction()) != null) {
                    defaultsAction.execute((Object)this);
                }
            }
            for (Project sub : project.getSubprojects()) {
                Task subArtifactoryTask = (Task)sub.getTasks().findByName(ARTIFACTORY_PUBLISH_TASK_NAME);
                if (subArtifactoryTask == null) continue;
                this.dependsOn(new Object[]{subArtifactoryTask});
            }
        }
        this.evaluated = true;
    }

    @Deprecated
    public void addDefaultArchiveConfiguration() {
        this.helperConfigurations.addDefaultArchiveConfiguration();
    }

    public void addDefaultPublications() {
        this.helperPublications.addDefaultPublications();
    }

    public void finalizeByDeployTask(Project project) {
        Task deployTask = (Task)project.getRootProject().getTasks().findByName(DEPLOY_TASK_NAME);
        if (deployTask == null) {
            throw new IllegalStateException(String.format("Could not find %s in the root project", DEPLOY_TASK_NAME));
        }
        this.finalizedBy(new Object[]{deployTask});
    }

    @Internal
    public boolean isEvaluated() {
        return this.evaluated;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setProperties(Map<String, CharSequence> props) {
        if (props == null || props.isEmpty()) {
            return;
        }
        this.properties.clear();
        for (Map.Entry<String, CharSequence> entry : props.entrySet()) {
            CharSequence value;
            String key = entry.getKey();
            if (!StringUtils.isNotBlank((CharSequence)key) || (value = entry.getValue()) == null) continue;
            this.properties.put((Object)key, (Object)value);
        }
    }

    @Input
    @Optional
    public Set<GradleDeployDetails> getDeployDetails() {
        return this.deployDetails;
    }

    public ArtifactSpecs getArtifactSpecs() {
        return this.artifactSpecs;
    }

    public void properties(Closure closure) {
        this.properties((Action<PropertiesConfig>)ConfigureUtil.configureUsing((Closure)closure));
    }

    public void properties(Action<PropertiesConfig> propertiesAction) {
        Project project = this.getProject();
        PropertiesConfig propertiesConfig = new PropertiesConfig(project);
        propertiesAction.execute((Object)propertiesConfig);
        this.artifactSpecs.clear();
        this.artifactSpecs.addAll((Collection)propertiesConfig.getArtifactSpecs());
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public void setPublishIvy(Object publishIvy) {
        this.setFlag(PUBLISH_IVY, this.toBoolean(publishIvy));
    }

    public void setPublishPom(Object publishPom) {
        this.setFlag(PUBLISH_POM, this.toBoolean(publishPom));
    }

    public void setPublishArtifacts(Object publishArtifacts) {
        this.setFlag(PUBLISH_ARTIFACTS, this.toBoolean(publishArtifacts));
    }

    @Nullable
    private Boolean getFlag(String flagName) {
        return this.flags.get(flagName);
    }

    private Boolean toBoolean(Object o) {
        return Boolean.valueOf(o.toString());
    }

    private void setFlag(String flagName, Boolean newValue) {
        this.flags.put(flagName, newValue);
    }
}

