/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.extractor.details;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.GradleException;

public class PublishArtifactInfo
implements Comparable<PublishArtifactInfo> {
    private final String name;
    private final String extension;
    private final String type;
    private final String classifier;
    private final Map<QName, String> extraInfo;
    private final File file;

    public PublishArtifactInfo(String name, String extension, String type, String classifier, File file) {
        this(name, extension, type, classifier, null, file);
    }

    public PublishArtifactInfo(String name, String extension, String type, String classifier, Map<QName, String> extraInfo, File file) {
        this.name = name;
        this.extension = extension;
        this.type = type;
        this.classifier = classifier;
        this.extraInfo = extraInfo;
        this.file = file;
    }

    public String getName() {
        return this.name;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getType() {
        return this.type;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public Map<QName, String> getExtraInfo() {
        return this.extraInfo;
    }

    public Map<String, String> getExtraTokens() {
        Map<QName, String> extraInfo;
        HashMap<String, String> extraTokens = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)this.getClassifier())) {
            extraTokens.put("classifier", this.getClassifier());
        }
        if ((extraInfo = this.getExtraInfo()) != null) {
            for (Map.Entry<QName, String> extraToken : extraInfo.entrySet()) {
                String key = extraToken.getKey().getLocalPart();
                if (extraTokens.containsKey(key)) {
                    throw new GradleException("Found duplicated extra info key defined '" + key + "'.");
                }
                extraTokens.put(key, extraToken.getValue());
            }
        }
        return extraTokens;
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public int compareTo(PublishArtifactInfo other) {
        return this.file.compareTo(other.getFile());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublishArtifactInfo info = (PublishArtifactInfo)o;
        return this.file.equals(info.file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }
}

