/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.config;

import groovy.lang.Closure;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.util.ConfigureUtil;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.gradle.plugin.artifactory.config.PublisherConfig;
import org.jfrog.gradle.plugin.artifactory.utils.GradleClientLogger;

public class ArtifactoryPluginConvention {
    private final Project project;
    private final ArtifactoryClientConfiguration clientConfig;
    private PublisherConfig publisherConfig;

    public ArtifactoryPluginConvention(Project project) {
        this.project = project;
        this.clientConfig = new ArtifactoryClientConfiguration((Log)new GradleClientLogger(project.getLogger()));
    }

    public void setContextUrl(String contextUrl) {
        this.clientConfig.publisher.setContextUrl(contextUrl);
    }

    public void publish(Closure<PublisherConfig> closure) {
        this.publish((Action<PublisherConfig>)ConfigureUtil.configureUsing(closure));
    }

    public void publish(Action<PublisherConfig> publishAction) {
        this.publisherConfig = new PublisherConfig(this);
        publishAction.execute((Object)this.publisherConfig);
    }

    public void buildInfo(Closure<ArtifactoryClientConfiguration.BuildInfoHandler> closure) {
        this.buildInfo((Action<ArtifactoryClientConfiguration.BuildInfoHandler>)ConfigureUtil.configureUsing(closure));
    }

    public void buildInfo(Action<ArtifactoryClientConfiguration.BuildInfoHandler> buildInfoAction) {
        buildInfoAction.execute((Object)this.clientConfig.info);
    }

    public void proxy(Closure<ArtifactoryClientConfiguration.ProxyHandler> closure) {
        this.proxy((Action<ArtifactoryClientConfiguration.ProxyHandler>)ConfigureUtil.configureUsing(closure));
    }

    public void proxy(Action<ArtifactoryClientConfiguration.ProxyHandler> buildInfoAction) {
        buildInfoAction.execute((Object)this.clientConfig.proxy);
    }

    public Project getProject() {
        return this.project;
    }

    public ArtifactoryClientConfiguration getClientConfig() {
        return this.clientConfig;
    }

    public PublisherConfig getPublisherConfig() {
        return this.publisherConfig;
    }
}

