/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.config;

import groovy.lang.GroovyObjectSupport;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.UnknownConfigurationException;
import org.gradle.internal.metaobject.DynamicInvokeResult;
import org.jfrog.build.extractor.clientConfiguration.ArtifactSpec;
import org.jfrog.build.extractor.clientConfiguration.ArtifactSpecs;

public class PropertiesConfig
extends GroovyObjectSupport {
    private final ArtifactSpecs artifactSpecs = new ArtifactSpecs();
    private final Project project;

    public PropertiesConfig(Project project) {
        this.project = project;
    }

    public Object invokeMethod(String name, Object args) {
        Object[] arguments = (Object[])args;
        if (arguments.length != 2 || !(arguments[0] instanceof Map)) {
            throw new GradleException("Invalid artifact properties spec: " + name + ", " + Arrays.toString(arguments) + ".\nExpected: configName artifactSpec, key1:val1, key2:val2");
        }
        if (!"all".equals(name)) {
            try {
                this.project.getConfigurations().getByName(name);
            }
            catch (UnknownConfigurationException e) {
                this.project.getLogger().info("Artifactory plugin: configuration '{}' not found in project '{}'", (Object)name, (Object)this.project.getPath());
            }
        }
        Map<String, String> props = this.convertToMap((Map)arguments[0]);
        String artifactNotation = arguments[1].toString();
        ArtifactSpec spec = ArtifactSpec.builder().artifactNotation(artifactNotation).configuration(name).properties(props).build();
        this.artifactSpecs.add((Object)spec);
        return DynamicInvokeResult.found();
    }

    private Map<String, String> convertToMap(Map<?, ?> inputMap) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        for (Map.Entry<?, ?> entry : inputMap.entrySet()) {
            String key = String.valueOf(entry.getKey());
            String value = String.valueOf(entry.getValue());
            resultMap.put(key, value);
        }
        return resultMap;
    }

    public ArtifactSpecs getArtifactSpecs() {
        return this.artifactSpecs;
    }
}

