/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.listener;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.DependencyResolutionListener;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.artifacts.result.ResolvedDependencyResult;
import org.jfrog.gradle.plugin.artifactory.utils.ProjectUtils;

public class ArtifactoryDependencyResolutionListener
implements DependencyResolutionListener {
    private final Map<String, Map<String, String[][]>> modulesHierarchyMap = new HashMap<String, Map<String, String[][]>>();

    public void beforeResolve(ResolvableDependencies dependencies) {
    }

    public void afterResolve(ResolvableDependencies dependencies) {
        if (!dependencies.getResolutionResult().getAllDependencies().isEmpty()) {
            this.updateModulesMap(dependencies);
        }
    }

    private void updateModulesMap(ResolvableDependencies dependencies) {
        String moduleId = ProjectUtils.getId(dependencies.getResolutionResult().getRoot().getModuleVersion());
        if (moduleId == null) {
            return;
        }
        Map dependenciesMap = this.modulesHierarchyMap.computeIfAbsent(moduleId, k -> new HashMap());
        this.updateDependencyMap(dependenciesMap, dependencies.getResolutionResult().getAllDependencies());
    }

    private void updateDependencyMap(Map<String, String[][]> dependencyMap, Set<? extends DependencyResult> dependencies) {
        for (DependencyResult dependencyResult : dependencies) {
            ResolvedDependencyResult resolvedDependency;
            String componentId;
            if (!(dependencyResult instanceof ResolvedDependencyResult) || dependencyMap.containsKey(componentId = ProjectUtils.getId((resolvedDependency = (ResolvedDependencyResult)dependencyResult).getSelected().getModuleVersion()))) continue;
            dependencyMap.put(componentId, this.getDependencyDependents(resolvedDependency));
        }
    }

    private String[][] getDependencyDependents(ResolvedDependencyResult resolvedDependency) {
        ArrayList<String> dependents = new ArrayList<String>();
        this.populateDependents(resolvedDependency, dependents);
        return new String[][]{dependents.toArray(new String[0])};
    }

    private void populateDependents(ResolvedDependencyResult dependency, List<String> dependents) {
        ResolvedComponentResult from = dependency.getFrom();
        if (from.getDependents().isEmpty()) {
            if (from.getSelectionReason().isExpected()) {
                dependents.add(ProjectUtils.getId(from.getModuleVersion()));
                return;
            }
            throw new RuntimeException("Failed populating dependency parents map: dependency has no dependents and is not root.");
        }
        ResolvedDependencyResult parent = (ResolvedDependencyResult)from.getDependents().iterator().next();
        String parentGav = ProjectUtils.getId(parent.getSelected().getModuleVersion());
        if (dependents.contains(parentGav)) {
            return;
        }
        dependents.add(parentGav);
        this.populateDependents(parent, dependents);
    }

    public Map<String, Map<String, String[][]>> getModulesHierarchyMap() {
        return this.modulesHierarchyMap;
    }
}

