/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.listener;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.gradle.BuildAdapter;
import org.gradle.StartParameter;
import org.gradle.api.Project;
import org.gradle.api.ProjectEvaluationListener;
import org.gradle.api.ProjectState;
import org.gradle.api.Task;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.publish.PublishingExtension;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.gradle.plugin.artifactory.config.ArtifactoryPluginConvention;
import org.jfrog.gradle.plugin.artifactory.task.ArtifactoryTask;
import org.jfrog.gradle.plugin.artifactory.utils.ConventionUtils;
import org.jfrog.gradle.plugin.artifactory.utils.ProjectUtils;
import org.jfrog.gradle.plugin.artifactory.utils.PublicationUtils;

public class ProjectsEvaluatedBuildListener
extends BuildAdapter
implements ProjectEvaluationListener {
    private static final Logger log = Logging.getLogger(ProjectsEvaluatedBuildListener.class);
    private final Set<Task> detailsCollectingTasks = Collections.newSetFromMap(new ConcurrentHashMap());

    private void evaluate(ArtifactoryTask collectDeployDetailsTask) {
        log.debug("Try to evaluate {}", (Object)collectDeployDetailsTask);
        Project project = collectDeployDetailsTask.getProject();
        ArtifactoryPluginConvention convention = ConventionUtils.getArtifactoryConvention(project);
        if (convention == null) {
            log.debug("Can't find artifactory convention.");
            return;
        }
        ArtifactoryClientConfiguration clientConfiguration = convention.getClientConfig();
        if (clientConfiguration == null) {
            log.debug("Client configuration not defined.");
            return;
        }
        ConventionUtils.updateConfig(clientConfiguration, project);
        if (collectDeployDetailsTask.isCiServerBuild()) {
            this.addCiAttributesToTask(collectDeployDetailsTask, clientConfiguration);
        }
        collectDeployDetailsTask.evaluateTask();
    }

    private void addCiAttributesToTask(ArtifactoryTask collectDeployDetailsTask, ArtifactoryClientConfiguration clientConfiguration) {
        PublishingExtension publishingExtension = (PublishingExtension)collectDeployDetailsTask.getProject().getExtensions().findByName("publishing");
        if (publishingExtension == null) {
            log.debug("Can't find publishing extensions that is defined for the project {}", (Object)collectDeployDetailsTask.getProject().getPath());
            return;
        }
        String publicationsNames = clientConfiguration.publisher.getPublications();
        if (StringUtils.isNotBlank((CharSequence)publicationsNames)) {
            collectDeployDetailsTask.publications(publicationsNames.split(","));
        } else if (ProjectUtils.hasOneOfComponents(collectDeployDetailsTask.getProject(), "java", "javaPlatform")) {
            PublicationUtils.addDefaultPublications(collectDeployDetailsTask, publishingExtension);
        }
    }

    public void afterEvaluate(Project project, ProjectState state) {
        StartParameter startParameter = project.getGradle().getStartParameter();
        Set tasks = project.getTasksByName("artifactoryPublish", false);
        tasks.forEach(task -> {
            if (!(task instanceof ArtifactoryTask)) {
                return;
            }
            ArtifactoryTask collectDeployDetailsTask = (ArtifactoryTask)((Object)task);
            this.detailsCollectingTasks.add((Task)collectDeployDetailsTask);
            collectDeployDetailsTask.finalizeByDeployTask(project);
            if (startParameter.isConfigureOnDemand()) {
                this.evaluate(collectDeployDetailsTask);
            }
        });
    }

    public void projectsEvaluated(Gradle gradle) {
        Set tasks = gradle.getRootProject().getTasksByName("artifactoryPublish", false);
        this.detailsCollectingTasks.addAll(tasks);
        this.detailsCollectingTasks.forEach(task -> {
            if (task instanceof ArtifactoryTask && !((ArtifactoryTask)((Object)task)).isEvaluated()) {
                ArtifactoryTask collectDeployDetailsTask = (ArtifactoryTask)((Object)task);
                this.evaluate(collectDeployDetailsTask);
                collectDeployDetailsTask.finalizeByDeployTask(collectDeployDetailsTask.getProject());
            }
        });
    }

    public void beforeEvaluate(Project project) {
    }
}

