/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.task;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import groovy.lang.Closure;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.PublicationContainer;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.internal.PublicationInternal;
import org.gradle.api.publish.ivy.IvyPublication;
import org.gradle.api.publish.ivy.internal.publication.IvyPublicationInternal;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.internal.publication.MavenPublicationInternal;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.ConfigureUtil;
import org.jfrog.build.extractor.clientConfiguration.ArtifactSpecs;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.gradle.plugin.artifactory.config.ArtifactoryPluginConvention;
import org.jfrog.gradle.plugin.artifactory.config.PropertiesConfig;
import org.jfrog.gradle.plugin.artifactory.config.PublisherConfig;
import org.jfrog.gradle.plugin.artifactory.extractor.details.GradleDeployDetails;
import org.jfrog.gradle.plugin.artifactory.utils.ConventionUtils;
import org.jfrog.gradle.plugin.artifactory.utils.PublicationUtils;

public class ArtifactoryTask
extends DefaultTask {
    private static final Logger log = Logging.getLogger(ArtifactoryTask.class);
    public static final String ARTIFACTORY_PUBLISH_TASK_NAME = "artifactoryPublish";
    private final Set<Object> publications = new HashSet<Object>();
    private final Multimap<String, CharSequence> properties = ArrayListMultimap.create();
    @Input
    public final ArtifactSpecs artifactSpecs = new ArtifactSpecs();
    private final Map<String, Boolean> flags = new HashMap<String, Boolean>();
    private boolean ciServerBuild = false;
    @Input
    public boolean skip = false;
    public Set<IvyPublication> ivyPublications = new HashSet<IvyPublication>();
    public Set<MavenPublication> mavenPublications = new HashSet<MavenPublication>();
    private boolean publishPublicationsSpecified = false;
    @Internal
    private Map<String, String> defaultProps;
    private boolean evaluated = false;
    private final Set<GradleDeployDetails> deployDetails = new TreeSet<GradleDeployDetails>();

    public void evaluateTask() {
        Action<ArtifactoryTask> defaultsAction;
        this.evaluated = true;
        Project project = this.getProject();
        if (this.isSkip()) {
            log.debug("'{}' skipped for project '{}'.", (Object)this.getPath(), (Object)project.getName());
            return;
        }
        for (Project sub : project.getSubprojects()) {
            Task subCollectInfoTask = (Task)sub.getTasks().findByName(ARTIFACTORY_PUBLISH_TASK_NAME);
            if (subCollectInfoTask == null) continue;
            this.dependsOn(new Object[]{subCollectInfoTask});
        }
        ArtifactoryPluginConvention convention = ConventionUtils.getConventionWithPublisher(project);
        if (convention == null) {
            log.debug("Can't find convention configured for {}", (Object)this.getPath());
            return;
        }
        this.artifactSpecs.clear();
        this.artifactSpecs.addAll((Collection)convention.getClientConfig().publisher.getArtifactSpecs());
        PublisherConfig config = convention.getPublisherConfig();
        if (config != null && (defaultsAction = config.getDefaultsAction()) != null) {
            defaultsAction.execute((Object)this);
        }
    }

    @TaskAction
    public void collectDeployDetails() {
        log.info("Collecting deployment details in task '{}'", (Object)this.getPath());
        if (!this.hasPublications()) {
            log.info("No publications to publish for project '{}'", (Object)this.getProject().getPath());
            return;
        }
        try {
            this.collectDetailsFromIvyPublications();
            this.collectDetailsFromMavenPublications();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot collect deploy details for " + this.getPath(), e);
        }
    }

    private void collectDetailsFromIvyPublications() {
        for (IvyPublication ivyPublication : this.ivyPublications) {
            String publicationName = ivyPublication.getName();
            if (!(ivyPublication instanceof IvyPublicationInternal)) {
                log.warn("Ivy publication name '{}' is of unsupported type '{}'!", (Object)publicationName, ivyPublication.getClass());
                continue;
            }
            PublicationUtils.extractIvyDeployDetails((IvyPublicationInternal)ivyPublication, this);
        }
    }

    private void collectDetailsFromMavenPublications() {
        for (MavenPublication mavenPublication : this.mavenPublications) {
            String publicationName = mavenPublication.getName();
            if (!(mavenPublication instanceof MavenPublicationInternal)) {
                log.warn("Maven publication name '{}' is of unsupported type '{}'!", (Object)publicationName, mavenPublication.getClass());
                continue;
            }
            PublicationUtils.extractMavenDeployDetails((MavenPublicationInternal)mavenPublication, this);
        }
    }

    public void publications(Object ... publications) {
        if (publications != null) {
            this.publications.addAll(Arrays.asList(publications));
            this.checkDependsOnArtifactsToPublish();
        }
    }

    private void checkDependsOnArtifactsToPublish() {
        this.extractPublications();
        if (!this.hasPublications()) {
            if (this.publishPublicationsSpecified) {
                log.warn("None of the specified publications matched for project '{}' - nothing to publish.", (Object)this.getProject().getPath());
            } else {
                log.debug("No publications specified for project '{}'", (Object)this.getProject().getPath());
            }
            return;
        }
        this.createDependencyOnIvyPublications();
        this.createDependencyOnMavenPublications();
    }

    private void extractPublications() {
        if (this.publications.isEmpty()) {
            return;
        }
        for (Object publication : this.publications) {
            if (publication instanceof CharSequence) {
                this.addPublication((CharSequence)publication);
                continue;
            }
            if (publication instanceof Publication) {
                this.addPublication((Publication)publication);
                continue;
            }
            log.error("Publication type '{}' not supported in task '{}'", publication, (Object)((Object)((Object)this)).getClass().getName());
        }
        this.publishPublicationsSpecified = true;
    }

    private void addPublication(CharSequence publication) {
        PublicationContainer container = ((PublishingExtension)this.getProject().getExtensions().getByType(PublishingExtension.class)).getPublications();
        if (publication.toString().equals("ALL_PUBLICATIONS")) {
            container.forEach(this::addPublication);
        } else {
            Publication publicationObj = (Publication)container.findByName(publication.toString());
            if (publicationObj != null) {
                this.addPublication(publicationObj);
            } else {
                log.debug("Publication named '{}' does not exist for project '{}' in task '{}'.", new Object[]{publication, this.getProject().getPath(), this.getPath()});
            }
        }
    }

    private void addPublication(Publication publicationObj) {
        if (publicationObj instanceof IvyPublication) {
            this.ivyPublications.add((IvyPublication)publicationObj);
        } else if (publicationObj instanceof MavenPublication) {
            this.mavenPublications.add((MavenPublication)publicationObj);
        } else {
            log.warn("Publication named '{}' in project '{}' is of unknown type '{}'", new Object[]{publicationObj.getName(), this.getProject().getPath(), publicationObj.getClass()});
        }
    }

    public void addDefaultPublications() {
        if (this.hasPublications()) {
            if (this.publishPublicationsSpecified) {
                log.warn("None of the specified publications matched for project '{}' - nothing to publish.", (Object)this.getProject().getPath());
            }
            return;
        }
        PublishingExtension publishingExtension = (PublishingExtension)this.getProject().getExtensions().findByName("publishing");
        if (publishingExtension == null) {
            log.warn("Can't find publishing extensions that is defined for the project {}", (Object)this.getProject().getPath());
            return;
        }
        this.addPublicationIfExists(publishingExtension, "mavenJava");
        this.addPublicationIfExists(publishingExtension, "mavenJavaPlatform");
        this.addPublicationIfExists(publishingExtension, "mavenWeb");
        this.addPublicationIfExists(publishingExtension, "ivyJava");
        this.checkDependsOnArtifactsToPublish();
    }

    private void addPublicationIfExists(PublishingExtension publishingExtension, String publicationName) {
        Publication publication = (Publication)publishingExtension.getPublications().findByName(publicationName);
        if (publication != null) {
            log.info("Publication '{}' exists but not specified for '{}' - adding to task publications.", (Object)this.getPath(), (Object)publicationName);
            this.addPublication(publication);
        }
    }

    private void createDependencyOnIvyPublications() {
        for (IvyPublication ivyPublication : this.ivyPublications) {
            if (!(ivyPublication instanceof IvyPublicationInternal)) {
                log.warn("Ivy publication name '{}' is of unsupported type '{}'!", (Object)ivyPublication.getName(), ivyPublication.getClass());
                continue;
            }
            this.dependsOnPublishable((Publication)ivyPublication);
            String capitalizedPublicationName = ivyPublication.getName().substring(0, 1).toUpperCase() + ivyPublication.getName().substring(1);
            this.dependsOn(new Object[]{String.format("%s:generateDescriptorFileFor%sPublication", this.getProject().getPath(), capitalizedPublicationName)});
        }
    }

    private void createDependencyOnMavenPublications() {
        for (MavenPublication mavenPublication : this.mavenPublications) {
            if (!(mavenPublication instanceof MavenPublicationInternal)) {
                log.warn("Maven publication name '{}' is of unsupported type '{}'!", (Object)mavenPublication.getName(), mavenPublication.getClass());
                continue;
            }
            this.dependsOnPublishable((Publication)mavenPublication);
            String capitalizedPublicationName = mavenPublication.getName().substring(0, 1).toUpperCase() + mavenPublication.getName().substring(1);
            this.dependsOn(new Object[]{String.format("%s:generatePomFileFor%sPublication", this.getProject().getPath(), capitalizedPublicationName)});
        }
    }

    private void dependsOnPublishable(Publication publication) {
        PublicationInternal publicationInternal = (PublicationInternal)publication;
        Object[] objectArray = new Object[1];
        objectArray[0] = () -> ((PublicationInternal)publicationInternal).getPublishableArtifacts();
        this.dependsOn(objectArray);
        publicationInternal.allPublishableArtifacts(xva$0 -> this.dependsOn(new Object[]{xva$0}));
    }

    public boolean hasPublications() {
        return !this.ivyPublications.isEmpty() || !this.mavenPublications.isEmpty();
    }

    public void finalizeByDeployTask(Project project) {
        Task deployTask = (Task)project.getRootProject().getTasks().findByName("artifactoryDeploy");
        if (deployTask == null) {
            throw new IllegalStateException(String.format("Could not find %s in the root project", "artifactoryDeploy"));
        }
        this.finalizedBy(new Object[]{deployTask});
    }

    public void properties(Closure<PropertiesConfig> closure) {
        this.properties((Action<PropertiesConfig>)ConfigureUtil.configureUsing(closure));
    }

    public void properties(Action<PropertiesConfig> propertiesAction) {
        PropertiesConfig propertiesConfig = new PropertiesConfig(this.getProject());
        propertiesAction.execute((Object)propertiesConfig);
        this.artifactSpecs.clear();
        this.artifactSpecs.addAll((Collection)propertiesConfig.getArtifactSpecs());
    }

    @Input
    @Optional
    public Set<GradleDeployDetails> getDeployDetails() {
        return this.deployDetails;
    }

    @Input
    public Set<Publication> getPublications() {
        HashSet<Publication> publications = new HashSet<Publication>();
        publications.addAll(this.ivyPublications);
        publications.addAll(this.mavenPublications);
        return publications;
    }

    @Input
    public Multimap<String, CharSequence> getProperties() {
        return this.properties;
    }

    @Input
    @Optional
    @Nullable
    public Boolean getPublishArtifacts() {
        return this.getFlag("publishArtifacts");
    }

    @Input
    @Optional
    @Nullable
    public Boolean getPublishIvy() {
        return this.getFlag("publishIvy");
    }

    @Input
    @Optional
    @Nullable
    public Boolean getPublishPom() {
        return this.getFlag("publishPom");
    }

    @Input
    public boolean isCiServerBuild() {
        return this.ciServerBuild;
    }

    public ArtifactSpecs getArtifactSpecs() {
        return this.artifactSpecs;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public Map<String, String> getDefaultProps() {
        if (this.defaultProps == null) {
            this.defaultProps = new HashMap<String, String>();
            PublicationUtils.addProps(this.defaultProps, this.getProperties());
            ArtifactoryClientConfiguration.PublisherHandler publisher = ConventionUtils.getPublisherHandler(this.getProject().getRootProject());
            if (publisher != null) {
                this.defaultProps.putAll((Map<String, String>)publisher.getMatrixParams());
            }
        }
        return this.defaultProps;
    }

    public void setCiServerBuild() {
        this.ciServerBuild = true;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public void setProperties(Map<String, CharSequence> props) {
        if (props == null || props.isEmpty()) {
            return;
        }
        this.properties.clear();
        for (Map.Entry<String, CharSequence> entry : props.entrySet()) {
            CharSequence value;
            String key = entry.getKey();
            if (!StringUtils.isNotBlank((CharSequence)key) || (value = entry.getValue()) == null) continue;
            this.properties.put((Object)key, (Object)value);
        }
    }

    public void setPublishArtifacts(Object publishArtifacts) {
        this.setFlag("publishArtifacts", this.toBoolean(publishArtifacts));
    }

    public void setPublishPom(Object publishPom) {
        this.setFlag("publishPom", this.toBoolean(publishPom));
    }

    public void setPublishIvy(Object publishIvy) {
        this.setFlag("publishIvy", this.toBoolean(publishIvy));
    }

    @Internal
    public boolean isEvaluated() {
        return this.evaluated;
    }

    private Boolean toBoolean(Object o) {
        return Boolean.valueOf(o.toString());
    }

    @Nullable
    private Boolean getFlag(String flagName) {
        return this.flags.get(flagName);
    }

    private void setFlag(String flagName, Boolean newValue) {
        this.flags.put(flagName, newValue);
    }
}

