/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.utils;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.ArtifactoryUploadResponse;
import org.jfrog.build.extractor.ci.BuildInfo;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.IncludeExcludePatterns;
import org.jfrog.build.extractor.clientConfiguration.PatternMatcher;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployDetails;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployableArtifactsUtils;
import org.jfrog.build.extractor.retention.Utils;
import org.jfrog.gradle.plugin.artifactory.extractor.details.GradleDeployDetails;
import org.jfrog.gradle.plugin.artifactory.task.ArtifactoryTask;
import org.jfrog.gradle.plugin.artifactory.utils.ConventionUtils;
import org.jfrog.gradle.plugin.artifactory.utils.GradleClientLogger;

public class DeployUtils {
    private static final Logger log = Logging.getLogger(DeployUtils.class);

    public static void deployTaskArtifacts(ArtifactoryClientConfiguration accRoot, Map<String, String> propsRoot, Map<String, Set<DeployDetails>> allDeployDetails, ArtifactoryTask artifactoryTask, String logPrefix) {
        try {
            if (!artifactoryTask.getDidWork()) {
                log.debug("Task '{}' did no work", (Object)artifactoryTask.getPath());
                return;
            }
            if (artifactoryTask.getDeployDetails().isEmpty()) {
                log.debug("Task '{}' has nothing to deploy", (Object)artifactoryTask.getPath());
                return;
            }
            ArtifactoryClientConfiguration.PublisherHandler taskPublisher = ConventionUtils.getPublisherHandler(artifactoryTask.getProject());
            if (taskPublisher == null) {
                log.debug("Task '{}' does not have publisher configured", (Object)artifactoryTask.getPath());
                return;
            }
            if (StringUtils.isBlank((CharSequence)taskPublisher.getContextUrl())) {
                log.debug("Task '{}' does not have publisher configured with contextUrl attribute", (Object)artifactoryTask.getPath());
                return;
            }
            if (!taskPublisher.isPublishArtifacts().booleanValue()) {
                log.debug("Task '{}' configured not to deploy artifacts", (Object)artifactoryTask.getPath());
                return;
            }
            DeployUtils.mergeRootAndModuleProps(taskPublisher, propsRoot);
            DeployUtils.configureArtifactoryManagerAndDeploy(accRoot, taskPublisher, artifactoryTask.getDeployDetails(), logPrefix);
            allDeployDetails.put(artifactoryTask.getProject().getName(), DeployUtils.getTaskDeployDetails(artifactoryTask));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void mergeRootAndModuleProps(ArtifactoryClientConfiguration.PublisherHandler modulePublisher, Map<String, String> propsRoot) {
        HashMap<String, String> moduleProps = new HashMap<String, String>(propsRoot);
        moduleProps.putAll(modulePublisher.getProps());
        modulePublisher.getProps().putAll(moduleProps);
    }

    private static void configureArtifactoryManagerAndDeploy(ArtifactoryClientConfiguration accRoot, ArtifactoryClientConfiguration.PublisherHandler publisher, Set<GradleDeployDetails> artifactsDeployDetails, String logPrefix) throws IOException {
        try (ArtifactoryManager artifactoryManager = DeployUtils.createArtifactoryManager(publisher);){
            DeployUtils.configureArtifactoryManager(accRoot, artifactoryManager);
            DeployUtils.deployArtifacts(artifactsDeployDetails, artifactoryManager, new IncludeExcludePatterns(publisher.getIncludePatterns(), publisher.getExcludePatterns()), logPrefix, publisher.getMinChecksumDeploySizeKb());
        }
    }

    private static ArtifactoryManager createArtifactoryManager(ArtifactoryClientConfiguration.PublisherHandler publisher) {
        String contextUrl = publisher.getContextUrl();
        String username = publisher.getUsername();
        String password = publisher.getPassword();
        if (StringUtils.isBlank((CharSequence)username)) {
            username = "";
        }
        if (StringUtils.isBlank((CharSequence)password)) {
            password = "";
        }
        return new ArtifactoryManager(contextUrl, username, password, (Log)new GradleClientLogger(log));
    }

    private static void configureArtifactoryManager(ArtifactoryClientConfiguration accRoot, ArtifactoryManager artifactoryManager) {
        if (accRoot.getTimeout() != null) {
            artifactoryManager.setConnectionTimeout(accRoot.getTimeout().intValue());
        }
        if (accRoot.getConnectionRetries() != null) {
            artifactoryManager.setConnectionRetries(accRoot.getConnectionRetries().intValue());
        }
        log.debug("Deploying artifacts using InsecureTls = " + accRoot.getInsecureTls());
        artifactoryManager.setInsecureTls(accRoot.getInsecureTls());
        DeployUtils.configureProxy(accRoot.proxy, artifactoryManager);
    }

    private static void configureProxy(ArtifactoryClientConfiguration.ProxyHandler proxy, ArtifactoryManager artifactoryManager) {
        String proxyHost = proxy.getHost();
        Integer proxyPort = proxy.getPort();
        if (StringUtils.isBlank((CharSequence)proxyHost) || proxyPort == null) {
            return;
        }
        log.debug("Found proxy host '{}' in port '{}'", (Object)proxyHost, (Object)proxyPort);
        String proxyUserName = proxy.getUsername();
        if (StringUtils.isNotBlank((CharSequence)proxyUserName)) {
            log.debug("Found proxy user name '{}'", (Object)proxyUserName);
            artifactoryManager.setProxyConfiguration(proxyHost, proxy.getPort().intValue(), proxyUserName, proxy.getPassword());
        } else {
            log.debug("No proxy user name and password found, using anonymous proxy");
            artifactoryManager.setProxyConfiguration(proxyHost, proxy.getPort().intValue());
        }
    }

    private static void deployArtifacts(Set<GradleDeployDetails> artifactsDeployDetails, ArtifactoryManager artifactoryManager, IncludeExcludePatterns patterns, String logPrefix, int minChecksumDeploySizeKb) throws IOException {
        for (GradleDeployDetails detail : artifactsDeployDetails) {
            DeployDetails deployDetails = detail.getDeployDetails();
            String artifactPath = deployDetails.getArtifactPath();
            if (PatternMatcher.pathConflicts((String)artifactPath, (IncludeExcludePatterns)patterns)) {
                log.lifecycle("Skipping the deployment of '{}' due to the defined include-exclude patterns.", new Object[]{artifactPath});
                continue;
            }
            try {
                ArtifactoryUploadResponse response = artifactoryManager.upload(deployDetails, logPrefix, Integer.valueOf(minChecksumDeploySizeKb));
                detail.getDeployDetails().setDeploySucceeded(Boolean.valueOf(true));
                detail.getDeployDetails().setSha256(response.getChecksums().getSha256());
            }
            catch (IOException e) {
                detail.getDeployDetails().setDeploySucceeded(Boolean.valueOf(false));
                detail.getDeployDetails().setSha256("");
                throw e;
            }
        }
    }

    private static Set<DeployDetails> getTaskDeployDetails(ArtifactoryTask artifactoryTask) {
        LinkedHashSet<DeployDetails> deployDetailsSet = new LinkedHashSet<DeployDetails>();
        for (GradleDeployDetails details : artifactoryTask.getDeployDetails()) {
            deployDetailsSet.add(details.getDeployDetails());
        }
        return deployDetailsSet;
    }

    public static void deployBuildInfo(ArtifactoryClientConfiguration accRoot, BuildInfo buildInfo, Map<String, Set<DeployDetails>> allDeployDetails) throws IOException {
        if (accRoot.publisher.getContextUrl() == null) {
            return;
        }
        try (ArtifactoryManager artifactoryManager = DeployUtils.createArtifactoryManager(accRoot.publisher);){
            DeployUtils.configureProxy(accRoot.proxy, artifactoryManager);
            if (accRoot.publisher.isPublishBuildInfo().booleanValue()) {
                log.debug("Publishing build info to artifactory at: '{}'", (Object)accRoot.publisher.getContextUrl());
                Utils.sendBuildAndBuildRetention((ArtifactoryManager)artifactoryManager, (BuildInfo)buildInfo, (ArtifactoryClientConfiguration)accRoot);
            }
            DeployUtils.exportDeployedArtifacts(accRoot, allDeployDetails);
        }
    }

    private static void exportDeployedArtifacts(ArtifactoryClientConfiguration accRoot, Map<String, Set<DeployDetails>> allDeployDetails) {
        String exportArtifactsPath = accRoot.info.getDeployableArtifactsFilePath();
        if (StringUtils.isEmpty((CharSequence)exportArtifactsPath)) {
            return;
        }
        try {
            log.debug("Exporting deployable artifacts to '{}'", (Object)exportArtifactsPath);
            DeployableArtifactsUtils.saveDeployableArtifactsToFile(allDeployDetails, (File)new File(exportArtifactsPath), (boolean)accRoot.info.isBackwardCompatibleDeployableArtifacts());
        }
        catch (Exception e) {
            log.error("Failed writing deployable artifacts to file: ", (Throwable)e);
            throw new RuntimeException("Failed writing deployable artifacts to file", e);
        }
    }
}

