/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.extractor;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jfrog.build.api.builder.ModuleType;
import org.jfrog.build.api.util.FileChecksumCalculator;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;
import org.jfrog.build.extractor.ModuleExtractor;
import org.jfrog.build.extractor.builder.ArtifactBuilder;
import org.jfrog.build.extractor.builder.DependencyBuilder;
import org.jfrog.build.extractor.builder.ModuleBuilder;
import org.jfrog.build.extractor.ci.Artifact;
import org.jfrog.build.extractor.ci.Dependency;
import org.jfrog.build.extractor.ci.Module;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployDetails;
import org.jfrog.gradle.plugin.artifactory.ArtifactoryPlugin;
import org.jfrog.gradle.plugin.artifactory.extractor.GradleDeployDetails;
import org.jfrog.gradle.plugin.artifactory.extractor.PublishArtifactInfo;
import org.jfrog.gradle.plugin.artifactory.listener.ArtifactoryDependencyResolutionListener;
import org.jfrog.gradle.plugin.artifactory.task.ArtifactoryTask;
import org.jfrog.gradle.plugin.artifactory.utils.ConventionUtils;
import org.jfrog.gradle.plugin.artifactory.utils.ProjectUtils;
import org.jfrog.gradle.plugin.artifactory.utils.TaskUtils;

public class GradleModuleExtractor
implements ModuleExtractor<Project> {
    private static final Logger log = Logging.getLogger(GradleModuleExtractor.class);

    public Module extractModule(Project project) {
        Set<GradleDeployDetails> gradleDeployDetails = this.getCollectedDeployDetails(project);
        return this.getModuleBuilder(project, gradleDeployDetails).build();
    }

    private Set<GradleDeployDetails> getCollectedDeployDetails(Project project) {
        ArtifactoryTask detailsCollectionTask = TaskUtils.findExecutedCollectionTask(project);
        if (detailsCollectionTask == null) {
            return Sets.newHashSet();
        }
        return detailsCollectionTask.getDeployDetails();
    }

    private ModuleBuilder getModuleBuilder(Project project, Set<GradleDeployDetails> gradleDeployDetails) {
        String moduleId = ProjectUtils.getId(project);
        String repo = gradleDeployDetails.stream().map(GradleDeployDetails::getDeployDetails).map(DeployDetails::getTargetRepository).findAny().orElse("");
        ModuleBuilder builder = new ModuleBuilder().type(ModuleType.GRADLE).id(moduleId).repository(repo);
        try {
            builder.dependencies(this.calculateDependencies(project, moduleId));
            ArtifactoryClientConfiguration.PublisherHandler publisher = ConventionUtils.getPublisherHandler(project);
            if (publisher == null) {
                log.warn("No publisher config found for project: " + project.getName());
                return builder;
            }
            builder.excludedArtifacts(this.calculateArtifacts(ProjectUtils.filterIncludeExcludeDetails(project, publisher, gradleDeployDetails, false)));
            builder.artifacts(this.calculateArtifacts(ProjectUtils.filterIncludeExcludeDetails(project, publisher, gradleDeployDetails, true)));
        }
        catch (Exception e) {
            log.error("Error occur during extraction: ", (Throwable)e);
        }
        return builder;
    }

    private List<Artifact> calculateArtifacts(Iterable<GradleDeployDetails> deployDetails) {
        return StreamSupport.stream(deployDetails.spliterator(), false).map(from -> {
            PublishArtifactInfo publishArtifact = from.getPublishArtifact();
            DeployDetails artifactDeployDetails = from.getDeployDetails();
            String artifactPath = artifactDeployDetails.getArtifactPath();
            return new ArtifactBuilder(artifactPath.substring(artifactPath.lastIndexOf(47) + 1)).type(BuildInfoExtractorUtils.getTypeString((String)publishArtifact.getType(), (String)publishArtifact.getClassifier(), (String)publishArtifact.getExtension())).md5(artifactDeployDetails.getMd5()).sha1(artifactDeployDetails.getSha1()).sha256(artifactDeployDetails.getSha256()).remotePath(artifactPath).build();
        }).collect(Collectors.toList());
    }

    private List<Dependency> calculateDependencies(Project project, String moduleId) throws Exception {
        ArtifactoryDependencyResolutionListener artifactoryDependencyResolutionListener = ((ArtifactoryPlugin)project.getRootProject().getPlugins().getPlugin(ArtifactoryPlugin.class)).getResolutionListener();
        Map<String, String[][]> requestedByMap = artifactoryDependencyResolutionListener.getModulesHierarchyMap().get(moduleId);
        ConfigurationContainer configurationSet = project.getConfigurations();
        ArrayList dependencies = Lists.newArrayList();
        for (Configuration configuration : configurationSet) {
            if (configuration.getState() != Configuration.State.RESOLVED) {
                log.info("Artifacts for configuration '{}' were not all resolved, skipping", (Object)configuration.getName());
                continue;
            }
            for (ResolvedArtifact artifact : configuration.getResolvedConfiguration().getResolvedArtifacts()) {
                Dependency extractedDependency = this.extractDependencyFromResolvedArtifact(configuration, artifact, requestedByMap, dependencies);
                if (extractedDependency == null) continue;
                dependencies.add(extractedDependency);
            }
        }
        return dependencies;
    }

    private Dependency extractDependencyFromResolvedArtifact(Configuration configuration, ResolvedArtifact artifact, Map<String, String[][]> requestedByMap, List<Dependency> dependencies) throws NoSuchAlgorithmException, IOException {
        File file = artifact.getFile();
        if (!file.exists()) {
            return null;
        }
        String depId = ProjectUtils.getId(artifact.getModuleVersion().getId());
        Dependency existingDependency = dependencies.stream().filter(input -> input.getId().equals(depId)).findAny().orElse(null);
        if (existingDependency != null) {
            Set existingScopes = existingDependency.getScopes();
            existingScopes.add(configuration.getName());
            existingDependency.setScopes(existingScopes);
            return null;
        }
        DependencyBuilder dependencyBuilder = new DependencyBuilder().type(BuildInfoExtractorUtils.getTypeString((String)artifact.getType(), (String)artifact.getClassifier(), (String)artifact.getExtension())).id(depId).scopes((Set)Sets.newHashSet((Object[])new String[]{configuration.getName()}));
        if (requestedByMap != null) {
            dependencyBuilder.requestedBy(requestedByMap.get(depId));
        }
        if (file.isFile()) {
            Map checksums = FileChecksumCalculator.calculateChecksums((File)file, (String[])new String[]{"MD5", "SHA1", "SHA-256"});
            dependencyBuilder.md5((String)checksums.get("MD5")).sha1((String)checksums.get("SHA1")).sha256((String)checksums.get("SHA-256"));
        }
        return dependencyBuilder.build();
    }
}

