/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.utils;

import com.google.common.collect.Multimap;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.apache.ivy.core.IvyPatternHelper;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.ivy.IvyArtifact;
import org.gradle.api.publish.ivy.IvyPublication;
import org.gradle.api.publish.ivy.internal.publication.IvyPublicationInternal;
import org.gradle.api.publish.ivy.internal.publisher.IvyNormalizedPublication;
import org.gradle.api.publish.ivy.internal.publisher.IvyPublicationIdentity;
import org.gradle.api.publish.ivy.plugins.IvyPublishPlugin;
import org.gradle.api.publish.maven.MavenArtifact;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.internal.publication.MavenPublicationInternal;
import org.gradle.api.publish.maven.internal.publisher.MavenNormalizedPublication;
import org.gradle.api.publish.maven.plugins.MavenPublishPlugin;
import org.jfrog.build.api.util.FileChecksumCalculator;
import org.jfrog.build.extractor.clientConfiguration.ArtifactSpec;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployDetails;
import org.jfrog.gradle.plugin.artifactory.extractor.GradleDeployDetails;
import org.jfrog.gradle.plugin.artifactory.extractor.PublishArtifactInfo;
import org.jfrog.gradle.plugin.artifactory.task.ArtifactoryTask;
import org.jfrog.gradle.plugin.artifactory.utils.ConventionUtils;
import org.jfrog.gradle.plugin.artifactory.utils.ProjectUtils;

public class PublicationUtils {
    private static final Logger log = Logging.getLogger(PublicationUtils.class);

    public static void addDefaultPublications(ArtifactoryTask collectDeployDetailsTask, PublishingExtension publishingExtension) {
        if (publishingExtension == null) {
            return;
        }
        Project project = collectDeployDetailsTask.getProject();
        PublicationUtils.addWarPublicationExtensions(project, publishingExtension);
        PublicationUtils.addJarPublicationExtensions(project, publishingExtension);
        collectDeployDetailsTask.addDefaultPublications();
    }

    private static void addWarPublicationExtensions(Project project, PublishingExtension publishingExtension) {
        Task warTask = (Task)project.getTasks().findByName("war");
        if (warTask == null || !warTask.getEnabled()) {
            return;
        }
        PublicationUtils.addMavenWebPublication(project, publishingExtension);
    }

    private static void addMavenWebPublication(Project project, PublishingExtension publishingExtension) {
        if (publishingExtension.getPublications().findByName("mavenWeb") != null) {
            return;
        }
        project.getPlugins().withType(MavenPublishPlugin.class, configureAction -> publishingExtension.publications(publications -> publications.create("mavenWeb", MavenPublication.class, mavenWeb -> mavenWeb.from((SoftwareComponent)project.getComponents().getByName("web")))));
    }

    private static void addJarPublicationExtensions(Project project, PublishingExtension publishingExtension) {
        Task jarTask = (Task)project.getTasks().findByName("jar");
        if (jarTask != null && !jarTask.getEnabled()) {
            return;
        }
        if (ProjectUtils.hasOneOfComponents(project, "java")) {
            PublicationUtils.addMavenJavaPublication(project, publishingExtension);
            PublicationUtils.addIvyJavaPublication(project, publishingExtension);
        }
        if (ProjectUtils.hasOneOfComponents(project, "javaPlatform")) {
            PublicationUtils.addMavenJavaPlatformPublication(project, publishingExtension);
        }
    }

    private static void addMavenJavaPublication(Project project, PublishingExtension publishingExtension) {
        if (publishingExtension.getPublications().findByName("mavenJava") != null) {
            return;
        }
        project.getPlugins().withType(MavenPublishPlugin.class, configureAction -> publishingExtension.publications(publications -> publications.create("mavenJava", MavenPublication.class, mavenJava -> mavenJava.from((SoftwareComponent)project.getComponents().getByName("java")))));
    }

    private static void addIvyJavaPublication(Project project, PublishingExtension publishingExtension) {
        if (publishingExtension.getPublications().findByName("ivyJava") != null) {
            return;
        }
        project.getPlugins().withType(IvyPublishPlugin.class, configureAction -> publishingExtension.publications(publications -> publications.create("ivyJava", IvyPublication.class, ivyJava -> ivyJava.from((SoftwareComponent)project.getComponents().getByName("java")))));
    }

    private static void addMavenJavaPlatformPublication(Project project, PublishingExtension publishingExtension) {
        if (publishingExtension.getPublications().findByName("mavenJavaPlatform") != null) {
            return;
        }
        project.getPlugins().withType(MavenPublishPlugin.class, configureAction -> publishingExtension.publications(publications -> publications.create("mavenJavaPlatform", MavenPublication.class, mavenJava -> mavenJava.from((SoftwareComponent)project.getComponents().getByName("javaPlatform")))));
    }

    public static void extractIvyDeployDetails(IvyPublicationInternal ivyPublicationInternal, ArtifactoryTask destination) {
        String publicationName = ivyPublicationInternal.getName();
        IvyNormalizedPublication ivyNormalizedPublication = ivyPublicationInternal.asNormalisedPublication();
        IvyPublicationIdentity projectIdentity = ivyNormalizedPublication.getProjectIdentity();
        Map extraInfo = ivyPublicationInternal.getDescriptor().getExtraInfo().asMap();
        PublicationUtils.extractIvyDescriptor(destination, publicationName, ivyNormalizedPublication, projectIdentity, extraInfo);
        PublicationUtils.extractIvyArtifacts(destination, publicationName, ivyNormalizedPublication, projectIdentity, extraInfo);
    }

    private static void extractIvyDescriptor(ArtifactoryTask destination, String publicationName, IvyNormalizedPublication ivyNormalizedPublication, IvyPublicationIdentity projectIdentity, Map<QName, String> extraInfo) {
        DeployDetails.Builder builder;
        File ivyFile = ivyNormalizedPublication.getIvyDescriptorFile();
        if (PublicationUtils.isPublishIvy(destination) && (builder = PublicationUtils.createArtifactBuilder(ivyFile, publicationName)) != null) {
            PublishArtifactInfo artifactInfo = new PublishArtifactInfo(projectIdentity.getModule(), "xml", "ivy", null, extraInfo, ivyFile);
            PublicationUtils.addIvyArtifactToDeployDetails(destination, publicationName, projectIdentity, builder, artifactInfo);
        }
    }

    private static boolean isPublishIvy(ArtifactoryTask task) {
        ArtifactoryClientConfiguration.PublisherHandler publisher = ConventionUtils.getPublisherHandler(task.getProject());
        if (publisher == null) {
            return false;
        }
        Boolean publishIvy = publisher.isIvy();
        if (publishIvy == null) {
            publishIvy = task.getPublishIvy();
        }
        return publishIvy != null ? publishIvy : true;
    }

    private static void extractIvyArtifacts(ArtifactoryTask destination, String publicationName, IvyNormalizedPublication ivyNormalizedPublication, IvyPublicationIdentity projectIdentity, Map<QName, String> extraInfo) {
        File ivyFile = ivyNormalizedPublication.getIvyDescriptorFile();
        Set artifacts = ivyNormalizedPublication.getAllArtifacts();
        for (IvyArtifact artifact : artifacts) {
            DeployDetails.Builder builder;
            File file = artifact.getFile();
            if (file.equals(ivyFile) || (builder = PublicationUtils.createArtifactBuilder(file, publicationName)) == null) continue;
            PublishArtifactInfo artifactInfo = new PublishArtifactInfo(artifact.getName(), artifact.getExtension(), artifact.getType(), artifact.getClassifier(), extraInfo, file);
            PublicationUtils.addIvyArtifactToDeployDetails(destination, publicationName, projectIdentity, builder, artifactInfo);
        }
    }

    private static void addIvyArtifactToDeployDetails(ArtifactoryTask destination, String publicationName, IvyPublicationIdentity projectIdentity, DeployDetails.Builder builder, PublishArtifactInfo artifactInfo) {
        ArtifactoryClientConfiguration.PublisherHandler publisher = ConventionUtils.getPublisherHandler(destination.getProject());
        if (publisher == null) {
            return;
        }
        String pattern = "ivy".equals(artifactInfo.getType()) ? publisher.getIvyPattern() : publisher.getIvyArtifactPattern();
        String gid = projectIdentity.getOrganisation();
        if (publisher.isM2Compatible()) {
            gid = gid.replace(".", "/");
        }
        Map<String, String> extraTokens = artifactInfo.getExtraTokens();
        String artifactPath = IvyPatternHelper.substitute((String)pattern, (String)gid, (String)projectIdentity.getModule(), (String)projectIdentity.getRevision(), (String)artifactInfo.getName(), (String)artifactInfo.getType(), (String)artifactInfo.getExtension(), (String)publicationName, extraTokens, null);
        builder.artifactPath(artifactPath);
        PublicationUtils.addArtifactInfoToDeployDetails(destination, publicationName, builder, artifactInfo, artifactPath);
    }

    public static void extractMavenDeployDetails(MavenPublicationInternal mavenPublicationInternal, ArtifactoryTask destination) {
        String publicationName = mavenPublicationInternal.getName();
        mavenPublicationInternal.asNormalisedPublication().getPomArtifact().getFile();
        MavenNormalizedPublication mavenNormalizedPublication = mavenPublicationInternal.asNormalisedPublication();
        PublicationUtils.extractMavenDescriptor(destination, publicationName, mavenPublicationInternal, mavenNormalizedPublication);
        PublicationUtils.extractMavenArtifacts(destination, publicationName, mavenPublicationInternal, mavenNormalizedPublication);
    }

    private static void extractMavenDescriptor(ArtifactoryTask destination, String publicationName, MavenPublicationInternal mavenPublicationInternal, MavenNormalizedPublication mavenNormalizedPublication) {
        DeployDetails.Builder builder;
        File pomFile = mavenNormalizedPublication.getPomArtifact().getFile();
        if (PublicationUtils.isPublishMaven(destination) && (builder = PublicationUtils.createArtifactBuilder(pomFile, publicationName)) != null) {
            PublishArtifactInfo artifactInfo = new PublishArtifactInfo(mavenPublicationInternal.getArtifactId(), "pom", "pom", null, pomFile);
            PublicationUtils.addMavenArtifactToDeployDetails(destination, publicationName, builder, artifactInfo, (MavenPublication)mavenPublicationInternal);
        }
    }

    private static boolean isPublishMaven(ArtifactoryTask task) {
        ArtifactoryClientConfiguration.PublisherHandler publisher = ConventionUtils.getPublisherHandler(task.getProject());
        if (publisher == null) {
            return false;
        }
        Boolean publishPom = publisher.isMaven();
        if (publishPom == null) {
            publishPom = task.getPublishPom();
        }
        return publishPom != null ? publishPom : true;
    }

    private static void extractMavenArtifacts(ArtifactoryTask destination, String publicationName, MavenPublicationInternal mavenPublicationInternal, MavenNormalizedPublication mavenNormalizedPublication) {
        Set artifacts = new HashSet();
        try {
            artifacts = mavenNormalizedPublication.getAdditionalArtifacts();
            if (mavenNormalizedPublication.getMainArtifact() != null) {
                PublicationUtils.createPublishArtifactInfoAndAddToDeployDetails(mavenNormalizedPublication.getMainArtifact(), destination, (MavenPublication)mavenPublicationInternal, publicationName);
            }
        }
        catch (IllegalStateException exception) {
            log.warn("Illegal state detected at Maven publication '{}', {}: {}", new Object[]{publicationName, destination.getProject(), exception.getMessage()});
        }
        for (MavenArtifact artifact : artifacts) {
            PublicationUtils.createPublishArtifactInfoAndAddToDeployDetails(artifact, destination, (MavenPublication)mavenPublicationInternal, publicationName);
        }
    }

    private static void createPublishArtifactInfoAndAddToDeployDetails(MavenArtifact artifact, ArtifactoryTask destination, MavenPublication mavenPublication, String publicationName) {
        File file = artifact.getFile();
        DeployDetails.Builder builder = PublicationUtils.createArtifactBuilder(file, publicationName);
        if (builder == null) {
            return;
        }
        PublishArtifactInfo artifactInfo = new PublishArtifactInfo(mavenPublication.getArtifactId(), artifact.getExtension(), artifact.getExtension(), artifact.getClassifier(), file);
        PublicationUtils.addMavenArtifactToDeployDetails(destination, publicationName, builder, artifactInfo, mavenPublication);
    }

    private static void addMavenArtifactToDeployDetails(ArtifactoryTask destination, String publicationName, DeployDetails.Builder builder, PublishArtifactInfo artifactInfo, MavenPublication mavenPublication) {
        Map<String, String> extraTokens = artifactInfo.getExtraTokens();
        String artifactPath = IvyPatternHelper.substitute((String)"[organisation]/[module]/[revision]/[artifact]-[revision](-[classifier]).[ext]", (String)mavenPublication.getGroupId().replace(".", "/"), (String)mavenPublication.getArtifactId(), (String)mavenPublication.getVersion(), (String)artifactInfo.getName(), (String)artifactInfo.getType(), (String)artifactInfo.getExtension(), (String)publicationName, extraTokens, null);
        builder.artifactPath(artifactPath);
        PublicationUtils.addArtifactInfoToDeployDetails(destination, publicationName, builder, artifactInfo, artifactPath);
    }

    private static void addArtifactInfoToDeployDetails(ArtifactoryTask destination, String publicationName, DeployDetails.Builder builder, PublishArtifactInfo artifactInfo, String artifactPath) {
        Project project = destination.getProject();
        ArtifactoryClientConfiguration.PublisherHandler publisher = ConventionUtils.getPublisherHandler(project);
        if (publisher != null) {
            builder.targetRepository(PublicationUtils.getTargetRepository(artifactPath, publisher));
            Map<String, String> propsToAdd = PublicationUtils.getPropsToAdd(destination, artifactInfo, publicationName);
            builder.addProperties(propsToAdd);
            destination.getDeployDetails().add(new GradleDeployDetails(artifactInfo, builder.build(), project));
        }
    }

    private static String getTargetRepository(String deployPath, ArtifactoryClientConfiguration.PublisherHandler publisher) {
        String snapshotsRepository = publisher.getSnapshotRepoKey();
        if (snapshotsRepository != null && deployPath.contains("-SNAPSHOT")) {
            return snapshotsRepository;
        }
        if (StringUtils.isNotEmpty((CharSequence)publisher.getReleaseRepoKey())) {
            return publisher.getReleaseRepoKey();
        }
        return publisher.getRepoKey();
    }

    private static Map<String, String> getPropsToAdd(ArtifactoryTask destination, PublishArtifactInfo artifact, String publicationName) {
        Project project = destination.getProject();
        HashMap<String, String> propsToAdd = new HashMap<String, String>(destination.getDefaultProps());
        ArtifactSpec spec = ArtifactSpec.builder().configuration(publicationName).group(project.getGroup().toString()).name(project.getName()).version(project.getVersion().toString()).classifier(artifact.getClassifier()).type(artifact.getType()).build();
        Multimap artifactSpecsProperties = destination.artifactSpecs.getProperties(spec);
        PublicationUtils.addProps(propsToAdd, (Multimap<String, CharSequence>)artifactSpecsProperties);
        return propsToAdd;
    }

    public static void addProps(Map<String, String> target, Multimap<String, CharSequence> props) {
        for (Map.Entry entry : props.entries()) {
            String key = (String)entry.getKey();
            Object value = ((CharSequence)entry.getValue()).toString();
            if (!target.containsKey(key)) {
                target.put(key, (String)value);
                continue;
            }
            value = target.get(key) + ", " + (String)value;
            target.put(key, (String)value);
        }
    }

    private static DeployDetails.Builder createArtifactBuilder(File file, String publicationName) {
        if (!file.exists()) {
            throw new GradleException("File '" + file.getAbsolutePath() + "' does not exist, and need to be published from publication " + publicationName);
        }
        DeployDetails.Builder artifactBuilder = new DeployDetails.Builder().file(file).packageType(DeployDetails.PackageType.GRADLE);
        try {
            Map checksums = FileChecksumCalculator.calculateChecksums((File)file, (String[])new String[]{"MD5", "SHA1", "SHA-256"});
            artifactBuilder.md5((String)checksums.get("MD5")).sha1((String)checksums.get("SHA1")).sha256((String)checksums.get("SHA-256"));
        }
        catch (Exception e) {
            throw new GradleException("Failed to calculate checksums for artifact: " + file.getAbsolutePath(), (Throwable)e);
        }
        return artifactBuilder;
    }
}

