/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.file.FileCollection;
import org.jfrog.gradle.plugin.artifactory.extractor.ModuleInfoFileProducer;
import org.jfrog.gradle.plugin.artifactory.task.ArtifactoryTask;
import org.jfrog.gradle.plugin.artifactory.task.DeployTask;
import org.jfrog.gradle.plugin.artifactory.task.ExtractModuleTask;
import org.jfrog.gradle.plugin.artifactory.utils.ProjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskUtils {
    private static final Logger log = LoggerFactory.getLogger(TaskUtils.class);

    private static <T extends Task> T createTaskInProject(String taskName, Class<T> taskClass, String taskDescription, Project project, boolean publishGroup) {
        log.debug("Configuring {} task for project (is root: {}) {}", new Object[]{taskName, ProjectUtils.isRootProject(project), project.getPath()});
        Task task = project.getTasks().create(taskName, taskClass);
        task.setDescription(taskDescription);
        if (publishGroup) {
            task.setGroup("publishing");
        }
        return (T)task;
    }

    public static ArtifactoryTask addCollectDeployDetailsTask(Project project) {
        Task task = (Task)project.getTasks().findByName("artifactoryPublish");
        if (task instanceof ArtifactoryTask) {
            return (ArtifactoryTask)task;
        }
        return TaskUtils.createTaskInProject("artifactoryPublish", ArtifactoryTask.class, "Collect artifacts to be later used to generate build-info and deploy to Artifactory.", project, true);
    }

    public static void addExtractModuleInfoTask(ArtifactoryTask collectDeployDetailsTask) {
        Project project = collectDeployDetailsTask.getProject();
        Object task = (Task)project.getTasks().findByName("extractModuleInfo");
        if (!(task instanceof ExtractModuleTask)) {
            task = TaskUtils.createTaskInProject("extractModuleInfo", ExtractModuleTask.class, "Extracts module information to an intermediate file.", project, false);
        }
        ExtractModuleTask extractModuleTask = (ExtractModuleTask)((Object)task);
        extractModuleTask.getOutputs().upToDateWhen(reuseOutputs -> false);
        extractModuleTask.getModuleFile().set(project.getLayout().getBuildDirectory().file("moduleInfo.json"));
        extractModuleTask.mustRunAfter(new Object[]{project.getTasks().withType(ArtifactoryTask.class)});
        project.getRootProject().getTasks().withType(DeployTask.class).configureEach(deployTask -> deployTask.registerModuleInfoProducer(new DefaultModuleInfoFileProducer(collectDeployDetailsTask, extractModuleTask)));
    }

    public static void addDeploymentTask(Project project) {
        Task task = (Task)project.getTasks().findByName("artifactoryDeploy");
        if (task instanceof DeployTask) {
            return;
        }
        TaskUtils.createTaskInProject("artifactoryDeploy", DeployTask.class, "Deploys artifacts and build-info to Artifactory.", project, false);
    }

    public static ArtifactoryTask findExecutedCollectionTask(Project project) {
        Set tasks = project.getTasksByName("artifactoryPublish", false);
        if (tasks.isEmpty()) {
            return null;
        }
        ArtifactoryTask artifactoryTask = (ArtifactoryTask)((Object)tasks.iterator().next());
        return artifactoryTask.getState().getDidWork() ? artifactoryTask : null;
    }

    public static List<ArtifactoryTask> getAllArtifactoryPublishTasks(Project project) {
        TaskExecutionGraph graph = project.getGradle().getTaskGraph();
        ArrayList<ArtifactoryTask> tasks = new ArrayList<ArtifactoryTask>();
        for (Task task : graph.getAllTasks()) {
            if (!(task instanceof ArtifactoryTask)) continue;
            tasks.add((ArtifactoryTask)task);
        }
        return tasks;
    }

    private static class DefaultModuleInfoFileProducer
    implements ModuleInfoFileProducer {
        private final ArtifactoryTask collectDeployDetailsTask;
        private final ExtractModuleTask extractModuleTask;

        DefaultModuleInfoFileProducer(ArtifactoryTask collectDeployDetailsTask, ExtractModuleTask extractModuleTask) {
            this.collectDeployDetailsTask = collectDeployDetailsTask;
            this.extractModuleTask = extractModuleTask;
        }

        @Override
        public boolean hasModules() {
            if (this.collectDeployDetailsTask != null && this.collectDeployDetailsTask.getProject().getState().getExecuted()) {
                return this.collectDeployDetailsTask.hasPublications();
            }
            return false;
        }

        @Override
        public FileCollection getModuleInfoFiles() {
            return this.extractModuleTask.getOutputs().getFiles();
        }
    }
}

