/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory;

import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Plugin;
import org.gradle.api.credentials.PasswordCredentials;
import org.gradle.api.initialization.Settings;
import org.jfrog.gradle.plugin.artifactory.utils.PluginUtils;

public class ArtifactoryPluginSettings
implements Plugin<Settings> {
    public void apply(Settings settings) {
        PluginUtils.assertGradleVersionSupported(settings.getGradle());
        String resolveContextUrl = System.getenv("ORG_GRADLE_PROJECT_artifactoryResolutionRepositoryUrl");
        if (resolveContextUrl == null) {
            return;
        }
        settings.getDependencyResolutionManagement().getRepositories().maven(mavenArtifactRepository -> {
            mavenArtifactRepository.setName("artifactoryResolutionRepository");
            mavenArtifactRepository.setUrl((Object)resolveContextUrl);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{System.getenv("ORG_GRADLE_PROJECT_artifactoryResolutionRepositoryUsername"), System.getenv("ORG_GRADLE_PROJECT_artifactoryResolutionRepositoryPassword")})) {
                mavenArtifactRepository.credentials(PasswordCredentials.class);
            }
        });
    }
}

