/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory;

import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Plugin;
import org.gradle.api.initialization.Settings;
import org.gradle.api.logging.Logging;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.gradle.plugin.artifactory.utils.GradleClientLogger;

public class ArtifactoryPluginSettings
implements Plugin<Settings> {
    private static final Log log = new GradleClientLogger(Logging.getLogger(ArtifactoryPluginSettings.class));

    public void apply(Settings settings) {
        ArtifactoryClientConfiguration.ResolverHandler resolver = this.getResolverHandler();
        if (resolver == null || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{resolver.getContextUrl(), resolver.getRepoKey()})) {
            return;
        }
        String contextUrl = StringUtils.appendIfMissing((String)resolver.getContextUrl(), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        settings.getDependencyResolutionManagement().getRepositories().maven(mavenArtifactRepository -> {
            mavenArtifactRepository.setName("artifactoryResolutionRepository");
            mavenArtifactRepository.setUrl((Object)(contextUrl + resolver.getRepoKey()));
            String username = resolver.getUsername();
            String password = resolver.getPassword();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{username, password})) {
                mavenArtifactRepository.credentials(credentials -> {
                    credentials.setUsername(username);
                    credentials.setPassword(password);
                });
            }
        });
    }

    private ArtifactoryClientConfiguration.ResolverHandler getResolverHandler() {
        Properties allProps = BuildInfoExtractorUtils.mergePropertiesWithSystemAndPropertyFile((Properties)new Properties(), (Log)log);
        ArtifactoryClientConfiguration configuration = new ArtifactoryClientConfiguration(log);
        configuration.fillFromProperties(allProps);
        return configuration.resolver;
    }
}

