/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.extractor.publication;

import java.io.File;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.tasks.GenerateModuleMetadata;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployDetails;
import org.jfrog.gradle.plugin.artifactory.extractor.PublishArtifactInfo;
import org.jfrog.gradle.plugin.artifactory.task.ArtifactoryTask;
import org.jfrog.gradle.plugin.artifactory.utils.PublicationUtils;

public abstract class PublicationExtractor<ActualPublication extends Publication> {
    protected ArtifactoryTask artifactoryTask;

    public PublicationExtractor(ArtifactoryTask artifactoryTask) {
        this.artifactoryTask = artifactoryTask;
    }

    public abstract void extractDeployDetails(ActualPublication var1);

    protected abstract void addArtifactToDeployDetails(ActualPublication var1, DeployDetails.Builder var2, PublishArtifactInfo var3);

    protected abstract String getPublicationArtifactId(ActualPublication var1);

    protected abstract boolean isApplicablePublication(Publication var1);

    public void extractModuleInfo() {
        for (GenerateModuleMetadata generateModuleMetadata : this.artifactoryTask.getProject().getTasks().withType(GenerateModuleMetadata.class)) {
            File moduleMetadata;
            Publication publication = (Publication)generateModuleMetadata.getPublication().get();
            if (!this.isApplicablePublication(publication) || !(moduleMetadata = (File)generateModuleMetadata.getOutputFile().getAsFile().get()).exists()) continue;
            DeployDetails.Builder builder = PublicationUtils.createArtifactBuilder(moduleMetadata, ((Publication)generateModuleMetadata.getPublication().get()).getName());
            Publication actualPublication = publication;
            PublishArtifactInfo artifactInfo = new PublishArtifactInfo(this.getPublicationArtifactId(actualPublication), "module", "module", null, moduleMetadata);
            this.addArtifactToDeployDetails(actualPublication, builder, artifactInfo);
        }
    }
}

