/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.extractor;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jfrog.build.api.builder.PromotionStatusBuilder;
import org.jfrog.build.extractor.BuildInfoExtractor;
import org.jfrog.build.extractor.ModuleExtractorUtils;
import org.jfrog.build.extractor.builder.BuildInfoBuilder;
import org.jfrog.build.extractor.ci.Agent;
import org.jfrog.build.extractor.ci.BuildAgent;
import org.jfrog.build.extractor.ci.BuildInfo;
import org.jfrog.build.extractor.ci.IssueTracker;
import org.jfrog.build.extractor.ci.Issues;
import org.jfrog.build.extractor.ci.MatrixParameter;
import org.jfrog.build.extractor.ci.Module;
import org.jfrog.build.extractor.ci.Vcs;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.packageManager.PackageManagerUtils;
import org.jfrog.gradle.plugin.artifactory.extractor.ModuleInfoFileProducer;

public class GradleBuildInfoExtractor
implements BuildInfoExtractor<Project> {
    private static final Logger log = Logging.getLogger(GradleBuildInfoExtractor.class);
    private final ArtifactoryClientConfiguration clientConf;
    private final List<ModuleInfoFileProducer> moduleInfoFileProducers;

    public GradleBuildInfoExtractor(ArtifactoryClientConfiguration clientConf, List<ModuleInfoFileProducer> moduleInfoFileProducers) {
        this.clientConf = clientConf;
        this.moduleInfoFileProducers = moduleInfoFileProducers;
    }

    public BuildInfo extract(Project rootProject) {
        BuildInfo buildInfo = this.createBuildInfoBuilder().build();
        PackageManagerUtils.collectEnvAndFilterProperties((ArtifactoryClientConfiguration)this.clientConf, (BuildInfo)buildInfo);
        this.removeResolutionProperties(buildInfo);
        log.debug("BuildInfo extracted = " + buildInfo);
        return buildInfo;
    }

    private BuildInfoBuilder createBuildInfoBuilder() {
        BuildInfoBuilder bib = this.createBaseBuilder();
        this.populateBuilderModulesFields(bib);
        for (Map.Entry runParam : this.clientConf.info.getRunParameters().entrySet()) {
            MatrixParameter matrixParameter = new MatrixParameter((String)runParam.getKey(), (String)runParam.getValue());
            bib.addRunParameters(matrixParameter);
        }
        this.populateBuilderAgentFields(bib);
        this.populateBuilderParentFields(bib);
        this.populateBuilderArtifactoryPluginVersionField(bib);
        Date buildStartDate = this.populateBuilderDateTimeFields(bib);
        String principal = this.populateBuilderPrincipalField(bib);
        String artifactoryPrincipal = this.populateBuilderArtifactoryPrincipalField(bib);
        this.populateBuilderPromotionFields(bib, buildStartDate, principal, artifactoryPrincipal);
        this.populateBuilderVcsFields(bib);
        this.populateBuilderIssueTrackerFields(bib);
        return bib;
    }

    private BuildInfoBuilder createBaseBuilder() {
        return new BuildInfoBuilder(this.clientConf.info.getBuildName()).number(this.clientConf.info.getBuildNumber()).project(this.clientConf.info.getProject());
    }

    private void populateBuilderModulesFields(BuildInfoBuilder bib) {
        Set<File> moduleFilesWithModules = this.moduleInfoFileProducers.stream().filter(ModuleInfoFileProducer::hasModules).flatMap(moduleInfoFileProducer -> moduleInfoFileProducer.getModuleInfoFiles().getFiles().stream()).collect(Collectors.toSet());
        moduleFilesWithModules.forEach(moduleFile -> {
            try {
                Module module = ModuleExtractorUtils.readModuleFromFile((File)moduleFile);
                List artifacts = module.getArtifacts();
                List dependencies = module.getDependencies();
                if (artifacts != null && !artifacts.isEmpty() || dependencies != null && !dependencies.isEmpty()) {
                    bib.addModule(module);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot load module info from file: " + moduleFile.getAbsolutePath(), e);
            }
        });
    }

    private void populateBuilderArtifactoryPluginVersionField(BuildInfoBuilder bib) {
        String artifactoryPluginVersion = this.clientConf.info.getArtifactoryPluginVersion();
        if (StringUtils.isBlank((CharSequence)artifactoryPluginVersion)) {
            artifactoryPluginVersion = "Unknown";
        }
        bib.artifactoryPluginVersion(artifactoryPluginVersion);
    }

    private void populateBuilderParentFields(BuildInfoBuilder bib) {
        String parentName = this.clientConf.info.getParentBuildName();
        String parentNumber = this.clientConf.info.getParentBuildNumber();
        if (parentName != null && parentNumber != null) {
            bib.parentName(parentName);
            bib.parentNumber(parentNumber);
        }
    }

    private Date populateBuilderDateTimeFields(BuildInfoBuilder bib) {
        String buildStartedIso = this.clientConf.info.getBuildStarted();
        Date buildStartDate = null;
        try {
            buildStartDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").parse(buildStartedIso);
        }
        catch (ParseException e) {
            log.error("Build start date format error: " + buildStartedIso, (Throwable)e);
        }
        bib.started(buildStartedIso);
        long durationMillis = buildStartDate != null ? System.currentTimeMillis() - buildStartDate.getTime() : 0L;
        bib.durationMillis(durationMillis);
        return buildStartDate;
    }

    private void populateBuilderAgentFields(BuildInfoBuilder bib) {
        BuildAgent buildAgent = new BuildAgent(this.clientConf.info.getBuildAgentName(), this.clientConf.info.getBuildAgentVersion());
        bib.buildAgent(buildAgent);
        String agentName = this.clientConf.info.getAgentName();
        String agentVersion = this.clientConf.info.getAgentVersion();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{agentName, agentVersion})) {
            bib.agent(new Agent(agentName, agentVersion));
        } else {
            bib.agent(new Agent(buildAgent.getName(), buildAgent.getVersion()));
        }
        String buildUrl = this.clientConf.info.getBuildUrl();
        if (StringUtils.isNotBlank((CharSequence)buildUrl)) {
            bib.url(buildUrl);
        }
    }

    private void populateBuilderVcsFields(BuildInfoBuilder bib) {
        Vcs vcs = new Vcs(this.clientConf.info.getVcsUrl(), this.clientConf.info.getVcsRevision(), this.clientConf.info.getVcsBranch(), this.clientConf.info.getVcsMessage());
        if (!vcs.isEmpty()) {
            bib.vcs(Collections.singletonList(vcs));
        }
    }

    private void populateBuilderIssueTrackerFields(BuildInfoBuilder bib) {
        String issueTrackerName = this.clientConf.info.issues.getIssueTrackerName();
        if (StringUtils.isNotBlank((CharSequence)issueTrackerName)) {
            Issues issues = new Issues();
            issues.setAggregateBuildIssues(this.clientConf.info.issues.getAggregateBuildIssues());
            issues.setAggregationBuildStatus(this.clientConf.info.issues.getAggregationBuildStatus());
            issues.setTracker(new IssueTracker(issueTrackerName, this.clientConf.info.issues.getIssueTrackerVersion()));
            Set affectedIssuesSet = this.clientConf.info.issues.getAffectedIssuesSet();
            if (!affectedIssuesSet.isEmpty()) {
                issues.setAffectedIssues(affectedIssuesSet);
            }
            bib.issues(issues);
        }
    }

    private String populateBuilderPrincipalField(BuildInfoBuilder bib) {
        String principal = this.overrideUserNameValueIfExists(this.clientConf.info.getPrincipal());
        bib.principal(principal);
        return principal;
    }

    private String populateBuilderArtifactoryPrincipalField(BuildInfoBuilder bib) {
        String artifactoryPrincipal = this.overrideUserNameValueIfExists(this.clientConf.publisher.getUsername());
        bib.artifactoryPrincipal(artifactoryPrincipal);
        return artifactoryPrincipal;
    }

    private String overrideUserNameValueIfExists(String val) {
        return StringUtils.isBlank((CharSequence)val) ? System.getProperty("user.name") : val;
    }

    private void populateBuilderPromotionFields(BuildInfoBuilder bib, Date buildStartDate, String principal, String artifactoryPrincipal) {
        if (this.clientConf.info.isReleaseEnabled().booleanValue()) {
            String stagingRepository = this.clientConf.publisher.getRepoKey();
            String comment = this.clientConf.info.getReleaseComment();
            if (comment == null) {
                comment = "";
            }
            bib.addStatus(new PromotionStatusBuilder("Staged").timestampDate(buildStartDate).comment(comment).repository(stagingRepository).ciUser(principal).user(artifactoryPrincipal).build());
        }
    }

    private void removeResolutionProperties(BuildInfo buildInfo) {
        Properties properties = buildInfo.getProperties();
        if (properties == null) {
            return;
        }
        properties.remove("buildInfo.env.ORG_GRADLE_PROJECT_artifactoryResolutionRepositoryUrl");
        properties.remove("buildInfo.env.ORG_GRADLE_PROJECT_artifactoryResolutionRepositoryUsername");
        properties.remove("buildInfo.env.ORG_GRADLE_PROJECT_artifactoryResolutionRepositoryPassword");
    }
}

