/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.dsl;

import groovy.lang.Closure;
import org.gradle.api.Action;
import org.gradle.util.ConfigureUtil;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.gradle.plugin.artifactory.dsl.ArtifactoryPluginConvention;
import org.jfrog.gradle.plugin.artifactory.task.ArtifactoryTask;

public class PublisherConfig {
    private final ArtifactoryClientConfiguration.PublisherHandler publisher;
    private final Repository repository;
    Action<ArtifactoryTask> defaultsAction;

    public PublisherConfig(ArtifactoryPluginConvention convention) {
        this.publisher = convention.getClientConfig().publisher;
        this.repository = new Repository(this.publisher);
    }

    public String getContextUrl() {
        return this.publisher.getContextUrl();
    }

    public void setContextUrl(String contextUrl) {
        this.publisher.setContextUrl(contextUrl);
    }

    public void defaults(Closure<ArtifactoryTask> closure) {
        this.defaults((Action<ArtifactoryTask>)ConfigureUtil.configureUsing(closure));
    }

    public void defaults(Action<ArtifactoryTask> defaultsAction) {
        this.defaultsAction = defaultsAction;
    }

    public Action<ArtifactoryTask> getDefaultsAction() {
        return this.defaultsAction;
    }

    public boolean isPublishBuildInfo() {
        return this.publisher.isPublishBuildInfo();
    }

    public void setPublishBuildInfo(boolean publishBuildInfo) {
        this.publisher.setPublishBuildInfo(Boolean.valueOf(publishBuildInfo));
    }

    public int getForkCount() {
        return this.publisher.getPublishForkCount();
    }

    public void setForkCount(int forkCount) {
        this.publisher.setPublishForkCount(forkCount);
    }

    public void repository(Closure<Repository> closure) {
        this.repository((Action<Repository>)ConfigureUtil.configureUsing(closure));
    }

    public void repository(Action<Repository> repositoryAction) {
        repositoryAction.execute((Object)this.repository);
    }

    public Repository getRepository() {
        return this.repository;
    }

    public static class IvyPublishInfo {
        private final ArtifactoryClientConfiguration.PublisherHandler publisher;

        public IvyPublishInfo(ArtifactoryClientConfiguration.PublisherHandler publisher) {
            this.publisher = publisher;
        }

        public void setIvyLayout(String ivyLayout) {
            this.publisher.setIvy(Boolean.valueOf(true));
            this.publisher.setIvyPattern(ivyLayout);
        }

        public String getIvyLayout() {
            return this.publisher.getIvyPattern();
        }

        public void setArtifactLayout(String artifactLayout) {
            this.publisher.setIvyArtifactPattern(artifactLayout);
        }

        public String getArtifactLayout() {
            return this.publisher.getIvyArtifactPattern();
        }

        public boolean getMavenCompatible() {
            return this.publisher.isM2Compatible();
        }

        public void setMavenCompatible(boolean mavenCompatible) {
            this.publisher.setM2Compatible(Boolean.valueOf(mavenCompatible));
        }
    }

    public static class Repository {
        private final ArtifactoryClientConfiguration.PublisherHandler publisher;
        private final IvyPublishInfo ivyPublishInfo;

        public Repository(ArtifactoryClientConfiguration.PublisherHandler publisher) {
            this.publisher = publisher;
            this.ivyPublishInfo = new IvyPublishInfo(publisher);
        }

        public String getRepoKey() {
            return this.publisher.getRepoKey();
        }

        public void setRepoKey(String repoKey) {
            this.publisher.setRepoKey(repoKey);
        }

        public String getUsername() {
            return this.publisher.getUsername();
        }

        public void setUsername(String username) {
            this.publisher.setUsername(username);
        }

        public String getPassword() {
            return this.publisher.getPassword();
        }

        public void setPassword(String password) {
            this.publisher.setPassword(password);
        }

        public void ivy(Closure<IvyPublishInfo> closure) {
            this.ivy((Action<IvyPublishInfo>)ConfigureUtil.configureUsing(closure));
        }

        public void ivy(Action<IvyPublishInfo> ivyAction) {
            ivyAction.execute((Object)this.ivyPublishInfo);
        }

        public IvyPublishInfo getIvy() {
            return this.ivyPublishInfo;
        }
    }
}

