/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.utils;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.GradleException;
import org.gradle.api.invocation.Gradle;
import org.jfrog.build.api.builder.ModuleType;
import org.jfrog.build.client.Version;
import org.jfrog.gradle.plugin.artifactory.Constant;

public class PluginUtils {
    public static void assertGradleVersionSupported(Gradle gradle) throws GradleException {
        String gradleVersion = gradle.getGradleVersion();
        if (!new Version(gradleVersion).isAtLeast(Constant.MIN_GRADLE_VERSION)) {
            throw new GradleException("Can't apply Artifactory Plugin on Gradle version " + gradleVersion + ". Minimum supported Gradle version is " + Constant.MIN_GRADLE_VERSION);
        }
    }

    public static ModuleType getModuleType(String moduleType) {
        if (StringUtils.isBlank((CharSequence)moduleType)) {
            return ModuleType.GRADLE;
        }
        try {
            return ModuleType.valueOf((String)StringUtils.upperCase((String)moduleType));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new GradleException("moduleType can only be one of " + Arrays.toString(ModuleType.values()), (Throwable)illegalArgumentException);
        }
    }
}

