/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.task;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.commons.collections4.MultiMapUtils;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.PublicationContainer;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.ivy.IvyPublication;
import org.gradle.api.publish.ivy.tasks.GenerateIvyDescriptor;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.tasks.GenerateMavenPom;
import org.gradle.api.publish.tasks.GenerateModuleMetadata;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskProvider;
import org.jfrog.build.api.builder.ModuleType;
import org.jfrog.build.extractor.clientConfiguration.ArtifactSpecs;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.gradle.plugin.artifactory.dsl.ArtifactoryPluginConvention;
import org.jfrog.gradle.plugin.artifactory.dsl.PropertiesConfig;
import org.jfrog.gradle.plugin.artifactory.dsl.PublisherConfig;
import org.jfrog.gradle.plugin.artifactory.extractor.GradleDeployDetails;
import org.jfrog.gradle.plugin.artifactory.extractor.publication.IvyPublicationExtractor;
import org.jfrog.gradle.plugin.artifactory.extractor.publication.MavenPublicationExtractor;
import org.jfrog.gradle.plugin.artifactory.utils.ExtensionsUtils;
import org.jfrog.gradle.plugin.artifactory.utils.PublicationUtils;

public class ArtifactoryTask
extends DefaultTask {
    private static final Logger log = Logging.getLogger(ArtifactoryTask.class);
    public static final String ARTIFACTORY_PUBLISH_TASK_NAME = "artifactoryPublish";
    private final Set<Object> publications = new HashSet<Object>();
    private final MultiValuedMap<String, CharSequence> properties = MultiMapUtils.newSetValuedHashMap();
    @Input
    public final ArtifactSpecs artifactSpecs = new ArtifactSpecs();
    private final Map<String, Boolean> flags = new HashMap<String, Boolean>();
    private boolean ciServerBuild = false;
    private String moduleType = ModuleType.GRADLE.toString();
    @Input
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Input field should be public")
    public boolean skip = false;
    public Set<IvyPublication> ivyPublications = new HashSet<IvyPublication>();
    public Set<MavenPublication> mavenPublications = new HashSet<MavenPublication>();
    private final Set<Configuration> archiveConfigurations = new HashSet<Configuration>();
    private boolean publishPublicationsSpecified = false;
    @Internal
    private Map<String, String> defaultProps;
    private boolean evaluated = false;
    private final Set<GradleDeployDetails> deployDetails = new TreeSet<GradleDeployDetails>();

    public void evaluateTask() {
        Action<ArtifactoryTask> defaultsAction;
        this.evaluated = true;
        Project project = this.getProject();
        if (this.isSkip()) {
            log.debug("'{}' skipped for project '{}'.", (Object)this.getPath(), (Object)project.getName());
            return;
        }
        for (Project sub : project.getSubprojects()) {
            try {
                TaskProvider subCollectInfoTask = sub.getTasks().named(ARTIFACTORY_PUBLISH_TASK_NAME);
                this.dependsOn(new Object[]{subCollectInfoTask});
            }
            catch (UnknownTaskException e) {
                log.debug("Can't find sub projects configured for {}", (Object)this.getPath());
            }
        }
        ArtifactoryPluginConvention extension = ExtensionsUtils.getExtensionWithPublisher(project);
        if (extension == null) {
            log.debug("Can't find extension configured for {}", (Object)this.getPath());
            return;
        }
        this.artifactSpecs.clear();
        this.artifactSpecs.addAll((Collection)extension.getClientConfig().publisher.getArtifactSpecs());
        PublisherConfig config = extension.getPublisherConfig();
        if (config != null && (defaultsAction = config.getDefaultsAction()) != null) {
            defaultsAction.execute((Object)this);
        }
    }

    @TaskAction
    public void collectDeployDetails() {
        log.info("Collecting deployment details in task '{}'", (Object)this.getPath());
        if (!this.hasPublications()) {
            log.info("No publications to publish for project '{}'", (Object)this.getProject().getPath());
            return;
        }
        try {
            this.collectDetailsFromIvyPublications();
            this.collectDetailsFromMavenPublications();
            this.collectDetailsFromConfigurations();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot collect deploy details for " + this.getPath(), e);
        }
    }

    private void collectDetailsFromIvyPublications() {
        IvyPublicationExtractor publicationExtractor = new IvyPublicationExtractor(this);
        publicationExtractor.extractModuleInfo();
        for (IvyPublication ivyPublication : this.ivyPublications) {
            publicationExtractor.extractDeployDetails(ivyPublication);
        }
    }

    private void collectDetailsFromMavenPublications() {
        MavenPublicationExtractor publicationExtractor = new MavenPublicationExtractor(this);
        publicationExtractor.extractModuleInfo();
        for (MavenPublication mavenPublication : this.mavenPublications) {
            publicationExtractor.extractDeployDetails(mavenPublication);
        }
    }

    private void collectDetailsFromConfigurations() {
        ArtifactoryClientConfiguration.PublisherHandler publisher = ExtensionsUtils.getPublisherHandler(this.getProject());
        if (publisher == null) {
            return;
        }
        for (Configuration configuration : this.archiveConfigurations) {
            PublicationUtils.extractArchivesDeployDetails(configuration, publisher, this);
        }
    }

    public void publications(Object ... publications) {
        if (publications != null) {
            this.publications.addAll(Arrays.asList(publications));
            this.checkDependsOnArtifactsToPublish();
        }
    }

    public void moduleType(String moduleType) {
        this.moduleType = moduleType;
    }

    private void checkDependsOnArtifactsToPublish() {
        this.extractPublications();
        if (!this.hasPublications()) {
            if (this.publishPublicationsSpecified) {
                log.warn("None of the specified publications matched for project '{}' - nothing to publish.", (Object)this.getProject().getPath());
            } else {
                log.debug("No publications specified for project '{}'", (Object)this.getProject().getPath());
            }
            return;
        }
        this.createDependencyOnIvyPublications();
        this.createDependencyOnMavenPublications();
        this.createDependencyOnModuleMetadata();
    }

    private void extractPublications() {
        if (this.publications.isEmpty()) {
            return;
        }
        for (Object publication : this.publications) {
            if (publication instanceof CharSequence) {
                this.addPublication((CharSequence)publication);
                continue;
            }
            if (publication instanceof Publication) {
                this.addPublication((Publication)publication);
                continue;
            }
            log.error("Publication type '{}' not supported in task '{}'", publication, (Object)((Object)((Object)this)).getClass().getName());
        }
        this.publishPublicationsSpecified = true;
    }

    private void addPublication(CharSequence publication) {
        PublicationContainer container = ((PublishingExtension)this.getProject().getExtensions().getByType(PublishingExtension.class)).getPublications();
        if (publication.toString().equals("ALL_PUBLICATIONS")) {
            container.forEach(this::addPublication);
        } else {
            Publication publicationObj = (Publication)container.findByName(publication.toString());
            if (publicationObj != null) {
                this.addPublication(publicationObj);
            } else {
                log.debug("Publication named '{}' does not exist for project '{}' in task '{}'.", new Object[]{publication, this.getProject().getPath(), this.getPath()});
            }
        }
    }

    private void addPublication(Publication publicationObj) {
        if (publicationObj instanceof IvyPublication) {
            this.ivyPublications.add((IvyPublication)publicationObj);
        } else if (publicationObj instanceof MavenPublication) {
            this.mavenPublications.add((MavenPublication)publicationObj);
        } else {
            log.warn("Publication named '{}' in project '{}' is of unknown type '{}'", new Object[]{publicationObj.getName(), this.getProject().getPath(), publicationObj.getClass()});
        }
    }

    public void addDefaultPublications() {
        if (this.hasPublications()) {
            if (this.publishPublicationsSpecified) {
                log.warn("None of the specified publications matched for project '{}' - nothing to publish.", (Object)this.getProject().getPath());
            }
            return;
        }
        PublishingExtension publishingExtension = (PublishingExtension)this.getProject().getExtensions().findByName("publishing");
        if (publishingExtension == null) {
            log.warn("Can't find publishing extensions that is defined for the project {}", (Object)this.getProject().getPath());
            return;
        }
        this.addPublicationIfExists(publishingExtension, "mavenJava");
        this.addPublicationIfExists(publishingExtension, "mavenJavaPlatform");
        this.addPublicationIfExists(publishingExtension, "mavenWeb");
        this.addPublicationIfExists(publishingExtension, "ivyJava");
        this.checkDependsOnArtifactsToPublish();
    }

    public void addDefaultArchiveConfigurations() {
        Project project = this.getProject();
        Configuration archiveConfig = (Configuration)project.getConfigurations().findByName("archives");
        if (archiveConfig == null) {
            log.debug("No publish configurations specified for project '{}' and the default '{}' configuration does not exist.", (Object)project.getPath(), (Object)"archives");
            return;
        }
        this.archiveConfigurations.add(archiveConfig);
        this.dependsOn(new Object[]{archiveConfig.getArtifacts()});
    }

    private void addPublicationIfExists(PublishingExtension publishingExtension, String publicationName) {
        Publication publication = (Publication)publishingExtension.getPublications().findByName(publicationName);
        if (publication != null) {
            log.info("Publication '{}' exists but not specified for '{}' - adding to task publications.", (Object)this.getPath(), (Object)publicationName);
            this.addPublication(publication);
        }
    }

    private void createDependencyOnIvyPublications() {
        for (IvyPublication ivyPublication : this.ivyPublications) {
            this.dependsOn(new Object[]{ivyPublication.getArtifacts()});
        }
        this.dependsOn(new Object[]{this.getProject().getTasks().withType(GenerateIvyDescriptor.class)});
    }

    private void createDependencyOnMavenPublications() {
        for (MavenPublication mavenPublication : this.mavenPublications) {
            this.dependsOn(new Object[]{mavenPublication.getArtifacts()});
        }
        this.dependsOn(new Object[]{this.getProject().getTasks().withType(GenerateMavenPom.class)});
    }

    public void createDependencyOnModuleMetadata() {
        try {
            Method component = GenerateModuleMetadata.class.getDeclaredMethod("component", new Class[0]);
            component.setAccessible(true);
            for (GenerateModuleMetadata generateModuleMetadata : this.getProject().getTasks().withType(GenerateModuleMetadata.class)) {
                if (component.invoke((Object)generateModuleMetadata, new Object[0]) == null) continue;
                this.dependsOn(new Object[]{generateModuleMetadata});
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
    }

    public boolean hasPublications() {
        return !this.ivyPublications.isEmpty() || !this.mavenPublications.isEmpty() || !this.archiveConfigurations.isEmpty();
    }

    public void finalizeByDeployTask(Project project) {
        try {
            TaskProvider deployTask = project.getRootProject().getTasks().named("artifactoryDeploy");
            this.finalizedBy(new Object[]{deployTask});
        }
        catch (UnknownTaskException e) {
            throw new IllegalStateException(String.format("Could not find %s in the root project", "artifactoryDeploy"), e);
        }
    }

    public void properties(Action<PropertiesConfig> propertiesAction) {
        PropertiesConfig propertiesConfig = new PropertiesConfig(this.getProject());
        propertiesAction.execute((Object)propertiesConfig);
        this.artifactSpecs.clear();
        this.artifactSpecs.addAll((Collection)propertiesConfig.getArtifactSpecs());
    }

    @Input
    @Optional
    public Set<GradleDeployDetails> getDeployDetails() {
        return this.deployDetails;
    }

    @Input
    @Optional
    public String getModuleType() {
        return this.moduleType;
    }

    @Input
    public Set<Publication> getPublications() {
        HashSet<Publication> publications = new HashSet<Publication>();
        publications.addAll(this.ivyPublications);
        publications.addAll(this.mavenPublications);
        return publications;
    }

    @Input
    public MultiValuedMap<String, CharSequence> getProperties() {
        return this.properties;
    }

    @Input
    @Optional
    @Nullable
    public Boolean getPublishArtifacts() {
        return this.getFlag("publishArtifacts");
    }

    @Input
    @Optional
    @Nullable
    public Boolean getPublishIvy() {
        return this.getFlag("publishIvy");
    }

    @Input
    @Optional
    @Nullable
    public Boolean getPublishPom() {
        return this.getFlag("publishPom");
    }

    @Input
    public boolean isCiServerBuild() {
        return this.ciServerBuild;
    }

    public ArtifactSpecs getArtifactSpecs() {
        return this.artifactSpecs;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public Map<String, String> getDefaultProps() {
        if (this.defaultProps == null) {
            this.defaultProps = new HashMap<String, String>();
            PublicationUtils.addProps(this.defaultProps, this.getProperties());
            ArtifactoryClientConfiguration.PublisherHandler publisher = ExtensionsUtils.getPublisherHandler(this.getProject().getRootProject());
            if (publisher != null) {
                this.defaultProps.putAll(publisher.getMatrixParams());
            }
        }
        return this.defaultProps;
    }

    public void setCiServerBuild() {
        this.ciServerBuild = true;
    }

    public void setModuleType(String moduleType) {
        this.moduleType = moduleType;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public void setProperties(Map<String, CharSequence> props) {
        if (props == null || props.isEmpty()) {
            return;
        }
        this.properties.clear();
        for (Map.Entry<String, CharSequence> entry : props.entrySet()) {
            CharSequence value;
            String key = entry.getKey();
            if (!StringUtils.isNotBlank((CharSequence)key) || (value = entry.getValue()) == null) continue;
            this.properties.put((Object)key, (Object)value);
        }
    }

    public void setPublishArtifacts(Object publishArtifacts) {
        this.setFlag("publishArtifacts", this.toBoolean(publishArtifacts));
    }

    public void setPublishPom(Object publishPom) {
        this.setFlag("publishPom", this.toBoolean(publishPom));
    }

    public void setPublishIvy(Object publishIvy) {
        this.setFlag("publishIvy", this.toBoolean(publishIvy));
    }

    @Internal
    public boolean isEvaluated() {
        return this.evaluated;
    }

    private Boolean toBoolean(Object o) {
        return Boolean.valueOf(o.toString());
    }

    @Nullable
    private Boolean getFlag(String flagName) {
        return this.flags.get(flagName);
    }

    private void setFlag(String flagName, Boolean newValue) {
        this.flags.put(flagName, newValue);
    }
}

