/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.utils;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.ivy.core.IvyPatternHelper;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.PublishArtifactSet;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.ivy.IvyPublication;
import org.gradle.api.publish.ivy.plugins.IvyPublishPlugin;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.plugins.MavenPublishPlugin;
import org.jfrog.build.api.util.FileChecksumCalculator;
import org.jfrog.build.extractor.clientConfiguration.ArtifactSpec;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployDetails;
import org.jfrog.gradle.plugin.artifactory.extractor.GradleDeployDetails;
import org.jfrog.gradle.plugin.artifactory.extractor.PublishArtifactInfo;
import org.jfrog.gradle.plugin.artifactory.task.ArtifactoryTask;
import org.jfrog.gradle.plugin.artifactory.utils.ExtensionsUtils;
import org.jfrog.gradle.plugin.artifactory.utils.ProjectUtils;

public class PublicationUtils {
    public static void addDefaultPublicationsOrArchiveConfigurations(ArtifactoryTask collectDeployDetailsTask, PublishingExtension publishingExtension) {
        if (publishingExtension == null) {
            collectDeployDetailsTask.addDefaultArchiveConfigurations();
            return;
        }
        Project project = collectDeployDetailsTask.getProject();
        PublicationUtils.addWarPublicationExtensions(project, publishingExtension);
        PublicationUtils.addJarPublicationExtensions(project, publishingExtension);
        collectDeployDetailsTask.addDefaultPublications();
    }

    private static void addWarPublicationExtensions(Project project, PublishingExtension publishingExtension) {
        Task warTask = (Task)project.getTasks().findByName("war");
        if (warTask == null || !warTask.getEnabled()) {
            return;
        }
        PublicationUtils.addMavenWebPublication(project, publishingExtension);
    }

    private static void addMavenWebPublication(Project project, PublishingExtension publishingExtension) {
        if (publishingExtension.getPublications().findByName("mavenWeb") != null) {
            return;
        }
        project.getPlugins().withType(MavenPublishPlugin.class, configureAction -> publishingExtension.publications(publications -> publications.create("mavenWeb", MavenPublication.class, mavenWeb -> mavenWeb.from((SoftwareComponent)project.getComponents().getByName("web")))));
    }

    private static void addJarPublicationExtensions(Project project, PublishingExtension publishingExtension) {
        Task jarTask = (Task)project.getTasks().findByName("jar");
        if (jarTask != null && !jarTask.getEnabled()) {
            return;
        }
        if (ProjectUtils.hasOneOfComponents(project, "java")) {
            PublicationUtils.addMavenJavaPublication(project, publishingExtension);
            PublicationUtils.addIvyJavaPublication(project, publishingExtension);
        }
        if (ProjectUtils.hasOneOfComponents(project, "javaPlatform")) {
            PublicationUtils.addMavenJavaPlatformPublication(project, publishingExtension);
        }
    }

    private static void addMavenJavaPublication(Project project, PublishingExtension publishingExtension) {
        if (publishingExtension.getPublications().findByName("mavenJava") != null) {
            return;
        }
        project.getPlugins().withType(MavenPublishPlugin.class, configureAction -> publishingExtension.publications(publications -> publications.create("mavenJava", MavenPublication.class, mavenJava -> mavenJava.from((SoftwareComponent)project.getComponents().getByName("java")))));
    }

    private static void addIvyJavaPublication(Project project, PublishingExtension publishingExtension) {
        if (publishingExtension.getPublications().findByName("ivyJava") != null) {
            return;
        }
        project.getPlugins().withType(IvyPublishPlugin.class, configureAction -> publishingExtension.publications(publications -> publications.create("ivyJava", IvyPublication.class, ivyJava -> ivyJava.from((SoftwareComponent)project.getComponents().getByName("java")))));
    }

    private static void addMavenJavaPlatformPublication(Project project, PublishingExtension publishingExtension) {
        if (publishingExtension.getPublications().findByName("mavenJavaPlatform") != null) {
            return;
        }
        project.getPlugins().withType(MavenPublishPlugin.class, configureAction -> publishingExtension.publications(publications -> publications.create("mavenJavaPlatform", MavenPublication.class, mavenJava -> mavenJava.from((SoftwareComponent)project.getComponents().getByName("javaPlatform")))));
    }

    public static void extractArchivesDeployDetails(Configuration configuration, ArtifactoryClientConfiguration.PublisherHandler publisher, ArtifactoryTask destination) {
        Project project = destination.getProject();
        PublishArtifactSet artifacts = configuration.getAllArtifacts();
        for (PublishArtifact artifact : artifacts) {
            File file = artifact.getFile();
            DeployDetails.Builder builder = PublicationUtils.createArtifactBuilder(file, configuration.getName());
            if (builder == null) continue;
            String gid = project.getGroup().toString();
            if (publisher.isM2Compatible()) {
                gid = gid.replace(".", "/");
            }
            HashMap<String, String> extraTokens = new HashMap<String, String>();
            if (StringUtils.isNotBlank((CharSequence)artifact.getClassifier())) {
                extraTokens.put("classifier", artifact.getClassifier());
            }
            String artifactPath = IvyPatternHelper.substitute((String)publisher.getIvyArtifactPattern(), (String)gid, (String)project.getName(), (String)project.getVersion().toString(), (String)artifact.getName(), (String)artifact.getType(), (String)artifact.getExtension(), (String)configuration.getName(), extraTokens, null);
            builder.artifactPath(artifactPath);
            PublishArtifactInfo artifactInfo = new PublishArtifactInfo(artifact.getName(), artifact.getExtension(), artifact.getType(), artifact.getClassifier(), null, file);
            PublicationUtils.addArtifactInfoToDeployDetails(destination, configuration.getName(), builder, artifactInfo, artifactPath);
        }
    }

    public static void addArtifactInfoToDeployDetails(ArtifactoryTask destination, String publicationName, DeployDetails.Builder builder, PublishArtifactInfo artifactInfo, String artifactPath) {
        Project project = destination.getProject();
        ArtifactoryClientConfiguration.PublisherHandler publisher = ExtensionsUtils.getPublisherHandler(project);
        if (publisher != null) {
            builder.targetRepository(PublicationUtils.getTargetRepository(artifactPath, publisher));
            Map<String, String> propsToAdd = PublicationUtils.getPropsToAdd(destination, artifactInfo, publicationName);
            builder.addProperties(propsToAdd);
            destination.getDeployDetails().add(new GradleDeployDetails(artifactInfo, builder.build(), project));
        }
    }

    private static String getTargetRepository(String deployPath, ArtifactoryClientConfiguration.PublisherHandler publisher) {
        String snapshotsRepository = publisher.getSnapshotRepoKey();
        if (snapshotsRepository != null && deployPath.contains("-SNAPSHOT")) {
            return snapshotsRepository;
        }
        if (StringUtils.isNotEmpty((CharSequence)publisher.getReleaseRepoKey())) {
            return publisher.getReleaseRepoKey();
        }
        return publisher.getRepoKey();
    }

    private static Map<String, String> getPropsToAdd(ArtifactoryTask destination, PublishArtifactInfo artifact, String publicationName) {
        Project project = destination.getProject();
        HashMap<String, String> propsToAdd = new HashMap<String, String>(destination.getDefaultProps());
        ArtifactSpec spec = ArtifactSpec.builder().configuration(publicationName).group(project.getGroup().toString()).name(project.getName()).version(project.getVersion().toString()).classifier(artifact.getClassifier()).type(artifact.getType()).build();
        MultiValuedMap artifactSpecsProperties = destination.artifactSpecs.getProperties(spec);
        PublicationUtils.addProps(propsToAdd, (MultiValuedMap<String, CharSequence>)artifactSpecsProperties);
        return propsToAdd;
    }

    public static void addProps(Map<String, String> target, MultiValuedMap<String, CharSequence> props) {
        for (Map.Entry entry : props.entries()) {
            String key = (String)entry.getKey();
            String value = ((CharSequence)entry.getValue()).toString();
            if (!target.containsKey(key)) {
                target.put(key, value);
                continue;
            }
            value = target.get(key) + ", " + value;
            target.put(key, value);
        }
    }

    public static DeployDetails.Builder createArtifactBuilder(File file, String publicationName) {
        if (!file.exists()) {
            throw new GradleException("File '" + file.getAbsolutePath() + "' does not exist, and need to be published from publication " + publicationName);
        }
        DeployDetails.Builder artifactBuilder = new DeployDetails.Builder().file(file).packageType(DeployDetails.PackageType.GRADLE);
        try {
            Map checksums = FileChecksumCalculator.calculateChecksums((File)file, (String[])new String[]{"MD5", "SHA1", "SHA-256"});
            artifactBuilder.md5((String)checksums.get("MD5")).sha1((String)checksums.get("SHA1")).sha256((String)checksums.get("SHA-256"));
        }
        catch (Exception e) {
            throw new GradleException("Failed to calculate checksums for artifact: " + file.getAbsolutePath(), (Throwable)e);
        }
        return artifactBuilder;
    }
}

