/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.task;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.TaskAction;
import org.jfrog.build.extractor.BuildInfoExtractorUtils;
import org.jfrog.build.extractor.ci.BuildInfo;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.deploy.DeployDetails;
import org.jfrog.gradle.plugin.artifactory.extractor.GradleBuildInfoExtractor;
import org.jfrog.gradle.plugin.artifactory.extractor.ModuleInfoFileProducer;
import org.jfrog.gradle.plugin.artifactory.task.ArtifactoryTask;
import org.jfrog.gradle.plugin.artifactory.utils.DeployUtils;
import org.jfrog.gradle.plugin.artifactory.utils.ExtensionsUtils;
import org.jfrog.gradle.plugin.artifactory.utils.TaskUtils;

public class DeployTask
extends DefaultTask {
    private static final Logger log = Logging.getLogger(DeployTask.class);
    private final List<ModuleInfoFileProducer> moduleInfoFileProducers = new ArrayList<ModuleInfoFileProducer>();

    public void registerModuleInfoProducer(ModuleInfoFileProducer moduleInfoFileProducer) {
        this.moduleInfoFileProducers.add(moduleInfoFileProducer);
    }

    @InputFiles
    public FileCollection getModuleInfoFiles() {
        ConfigurableFileCollection moduleInfoFiles = this.getProject().files(new Object[0]);
        this.moduleInfoFileProducers.forEach(moduleInfoFileProducer -> {
            moduleInfoFiles.from(new Object[]{moduleInfoFileProducer.getModuleInfoFiles()});
            moduleInfoFiles.builtBy(new Object[]{moduleInfoFileProducer.getModuleInfoFiles().getBuildDependencies()});
        });
        return moduleInfoFiles;
    }

    @TaskAction
    public void extractBuildInfoAndDeploy() throws IOException {
        log.debug("Extracting build-info and deploying build details in task '{}'", (Object)this.getPath());
        ArtifactoryClientConfiguration accRoot = ExtensionsUtils.getArtifactoryExtension(this.getProject()).getClientConfig();
        Map<String, Set<DeployDetails>> allDeployedDetails = this.deployArtifactsFromTasks(accRoot);
        this.handleBuildInfoOperations(accRoot, allDeployedDetails);
        this.deleteBuildInfoPropertiesFile();
    }

    private Map<String, Set<DeployDetails>> deployArtifactsFromTasks(ArtifactoryClientConfiguration accRoot) {
        Map propsRoot = accRoot.publisher.getProps();
        ArtifactoryClientConfiguration.addDefaultPublisherAttributes((ArtifactoryClientConfiguration)accRoot, (String)this.getProject().getRootProject().getName(), (String)"Gradle", (String)this.getProject().getGradle().getGradleVersion());
        ConcurrentHashMap<String, Set<DeployDetails>> allDeployDetails = new ConcurrentHashMap<String, Set<DeployDetails>>();
        List<ArtifactoryTask> orderedTasks = TaskUtils.getAllArtifactoryPublishTasks(this.getProject());
        int publishForkCount = accRoot.publisher.getPublishForkCount();
        if (publishForkCount <= 1) {
            orderedTasks.forEach(t -> DeployUtils.deployTaskArtifacts(accRoot, propsRoot, allDeployDetails, t, null));
        } else {
            try {
                ExecutorService executor = Executors.newFixedThreadPool(publishForkCount);
                CompletableFuture<Void> allUploads = CompletableFuture.allOf((CompletableFuture[])orderedTasks.stream().map(t -> CompletableFuture.runAsync(() -> DeployUtils.deployTaskArtifacts(accRoot, propsRoot, allDeployDetails, t, "[" + Thread.currentThread().getName() + "]"), executor)).toArray(CompletableFuture[]::new));
                allUploads.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return allDeployDetails;
    }

    private void handleBuildInfoOperations(ArtifactoryClientConfiguration accRoot, Map<String, Set<DeployDetails>> allDeployedDetails) throws IOException {
        GradleBuildInfoExtractor gbie = new GradleBuildInfoExtractor(accRoot, this.moduleInfoFileProducers);
        BuildInfo buildInfo = gbie.extract(this.getProject().getRootProject());
        this.exportBuildInfoToFileSystem(accRoot, buildInfo);
        DeployUtils.deployBuildInfo(accRoot, buildInfo, allDeployedDetails);
    }

    private void exportBuildInfoToFileSystem(ArtifactoryClientConfiguration accRoot, BuildInfo buildInfo) throws IOException {
        try {
            this.exportBuildInfo(buildInfo, this.getExportFile(accRoot));
            if (!StringUtils.isEmpty((CharSequence)accRoot.info.getGeneratedBuildInfoFilePath())) {
                this.exportBuildInfo(buildInfo, new File(accRoot.info.getGeneratedBuildInfoFilePath()));
            }
        }
        catch (Exception e) {
            log.error("Failed writing build info to file: ", (Throwable)e);
            throw new IOException("Failed writing build info to file", e);
        }
    }

    private File getExportFile(ArtifactoryClientConfiguration clientConf) {
        String fileExportPath = clientConf.getExportFile();
        if (StringUtils.isNotBlank((CharSequence)fileExportPath)) {
            return new File(fileExportPath);
        }
        Project rootProject = this.getProject().getRootProject();
        return ((RegularFile)rootProject.getLayout().getBuildDirectory().file("build-info.json").get()).getAsFile();
    }

    private void exportBuildInfo(BuildInfo buildInfo, File toFile) throws IOException {
        log.debug("Exporting generated build info to '{}'", (Object)toFile.getAbsolutePath());
        BuildInfoExtractorUtils.saveBuildInfoToFile((BuildInfo)buildInfo, (File)toFile);
    }

    private void deleteBuildInfoPropertiesFile() {
        File file;
        String propertyFilePath = System.getenv("buildInfoConfig.propertiesFile");
        if (StringUtils.isBlank((CharSequence)propertyFilePath)) {
            propertyFilePath = System.getenv("BUILDINFO_PROPFILE");
        }
        if (StringUtils.isNotBlank((CharSequence)propertyFilePath) && (file = new File(propertyFilePath)).exists() && !file.delete()) {
            log.warn("Can't delete build-info config properties file at {}", (Object)propertyFilePath);
        }
    }
}

