/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.gradle.plugin.artifactory.dsl;

import org.gradle.api.Action;
import org.gradle.api.Project;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.gradle.plugin.artifactory.dsl.PublisherConfig;
import org.jfrog.gradle.plugin.artifactory.utils.GradleClientLogger;

public class ArtifactoryPluginConvention {
    private final Project project;
    private final ArtifactoryClientConfiguration clientConfig;
    private PublisherConfig publisherConfig;

    public ArtifactoryPluginConvention(Project project) {
        this.project = project;
        this.clientConfig = new ArtifactoryClientConfiguration((Log)new GradleClientLogger(project.getLogger()));
    }

    public void setContextUrl(String contextUrl) {
        this.clientConfig.publisher.setContextUrl(contextUrl);
    }

    public void publish(Action<PublisherConfig> publishAction) {
        this.publisherConfig = (PublisherConfig)this.project.getObjects().newInstance(PublisherConfig.class, new Object[]{this.project.getObjects(), this});
        publishAction.execute((Object)this.publisherConfig);
    }

    public void buildInfo(Action<ArtifactoryClientConfiguration.BuildInfoHandler> buildInfoAction) {
        buildInfoAction.execute((Object)this.clientConfig.info);
    }

    public void proxy(Action<ArtifactoryClientConfiguration.ProxyHandler> buildInfoAction) {
        buildInfoAction.execute((Object)this.clientConfig.proxy);
    }

    public Project getProject() {
        return this.project;
    }

    public ArtifactoryClientConfiguration getClientConfig() {
        return this.clientConfig;
    }

    public PublisherConfig getPublisherConfig() {
        return this.publisherConfig;
    }
}

