/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.buildScanTable;

import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class BuildScanTableElement {
    private final String fileDisplayName;
    private final String issueType;
    private final String fileSha256;
    private final String issueSummary;
    private final String issueDescription;

    public BuildScanTableElement(String fileDisplayName, String fileSha256, String issueType, String issueSummary, String issueDescription) {
        this.fileDisplayName = fileDisplayName;
        this.fileSha256 = fileSha256;
        this.issueType = issueType;
        this.issueSummary = issueSummary;
        this.issueDescription = issueDescription;
    }

    public String getFileDisplayName() {
        return this.fileDisplayName == null ? "" : this.fileDisplayName;
    }

    public String getIssueType() {
        return StringUtils.capitalize(this.issueType == null ? "" : this.issueType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildScanTableElement that = (BuildScanTableElement)o;
        return Objects.equals(this.fileDisplayName, that.fileDisplayName) && Objects.equals(this.issueType, that.issueType) && Objects.equals(this.fileSha256, that.fileSha256) && Objects.equals(this.issueSummary, that.issueSummary) && Objects.equals(this.issueDescription, that.issueDescription);
    }

    public int hashCode() {
        return Objects.hash(this.fileDisplayName, this.issueType, this.fileSha256, this.issueSummary, this.issueDescription);
    }
}

