/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.buildScanTable;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jfrog.build.api.util.CommonUtils;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.client.artifactoryXrayResponse.Alert;
import org.jfrog.build.client.artifactoryXrayResponse.ArtifactoryXrayResponse;
import org.jfrog.build.client.artifactoryXrayResponse.ImpactedArtifact;
import org.jfrog.build.client.artifactoryXrayResponse.InfectedFile;
import org.jfrog.build.client.artifactoryXrayResponse.Issue;
import org.jfrog.build.extractor.buildScanTable.BuildScanTableElement;
import org.jfrog.build.extractor.scan.Severity;

public class BuildScanTableHelper {
    private ArtifactoryXrayResponse scanResult;
    private Map<Severity, Set<BuildScanTableElement>> table;
    private Log log;
    private int longestDisplayName = 0;
    private String tableFormat = "";
    public String TABLE_HEADLINE = "Xray Scan Summary:";
    public List<String> TABLE_HEADERS = Arrays.asList("#", "Component", "Severity", "Type");

    public void PrintTable(ArtifactoryXrayResponse scanResult, Log log) {
        this.scanResult = scanResult;
        this.log = log;
        this.generateResultTable();
        this.updateTableFormat();
        this.print();
    }

    private void print() {
        int line = 1;
        Severity[] severities = Severity.values();
        this.log.info(this.TABLE_HEADLINE);
        this.printLine(this.TABLE_HEADERS.toArray());
        for (int i = severities.length - 1; i >= 0; --i) {
            Severity severity = severities[i];
            Set<BuildScanTableElement> elements = this.table.get((Object)severity);
            if (elements == null) continue;
            for (BuildScanTableElement element : elements) {
                this.printLine(line, element.getFileDisplayName(), severity.getSeverityName(), element.getIssueType());
                ++line;
            }
        }
        this.log.info("");
    }

    private void printLine(Object ... args) {
        this.log.info(String.format(this.tableFormat, args));
    }

    private void updateTableFormat() {
        this.tableFormat = "%-6s%-" + (this.longestDisplayName + 5) + "s%-15s%-10s";
    }

    private void generateResultTable() {
        this.table = new HashMap<Severity, Set<BuildScanTableElement>>();
        for (Alert alert : CommonUtils.emptyIfNull(this.scanResult.getAlerts())) {
            for (Issue issue : CommonUtils.emptyIfNull(alert.getIssues())) {
                for (ImpactedArtifact impactedArtifact : CommonUtils.emptyIfNull(issue.getImpactedArtifacts())) {
                    for (InfectedFile infectedFile : CommonUtils.emptyIfNull(impactedArtifact.getInfectedFiles())) {
                        this.addElement(issue, infectedFile);
                    }
                }
            }
        }
    }

    private void addElement(Issue issue, InfectedFile infectedFile) {
        Severity severity = Severity.fromString(issue.getSeverity());
        BuildScanTableElement buildScanTableElement = new BuildScanTableElement(infectedFile.getDisplayName(), infectedFile.getSha256(), issue.getType(), issue.getSummary(), issue.getDescription());
        Set<BuildScanTableElement> elements = this.table.get((Object)severity);
        if (elements == null) {
            elements = new HashSet<BuildScanTableElement>();
        }
        elements.add(buildScanTableElement);
        this.table.put(severity, elements);
        if (infectedFile.getDisplayName() != null && infectedFile.getDisplayName().length() > this.longestDisplayName) {
            this.longestDisplayName = infectedFile.getDisplayName().length();
        }
    }
}

