/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.client.artifactory.services;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.jfrog.build.api.dependency.PropertySearchResult;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.client.JFrogService;

public class SearchArtifactsByProperties
extends JFrogService<PropertySearchResult> {
    private static final String SEARCH_ARTIFACT_BY_PROPERTIES_ENDPOINT = "api/search/prop?";
    private final String properties;

    public SearchArtifactsByProperties(String properties, Log log) {
        super(log);
        this.properties = properties;
    }

    @Override
    public HttpRequestBase createRequest() throws IOException {
        String replacedProperties = StringUtils.replaceEach(this.properties, new String[]{";", "+"}, new String[]{"&", ""});
        String url = SEARCH_ARTIFACT_BY_PROPERTIES_ENDPOINT + replacedProperties;
        return new HttpGet(url);
    }

    @Override
    protected void handleUnsuccessfulResponse(HttpEntity entity) throws IOException {
        this.log.error("Failed to search artifact by the properties '" + this.properties + "'");
        SearchArtifactsByProperties.throwException(entity, this.getStatusCode());
    }

    @Override
    protected void setResponse(InputStream stream) throws IOException {
        this.result = this.getMapper().readValue(stream, PropertySearchResult.class);
    }
}

