/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.client.artifactory.services;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.jfrog.build.api.Build;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.client.VoidJFrogService;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.services.PublishBuildInfo;
import org.jfrog.build.extractor.clientConfiguration.util.JsonUtils;

public class SendModuleInfo
extends VoidJFrogService {
    public static final String APPLICATION_VND_ORG_JFROG_ARTIFACTORY_JSON = "application/vnd.org.jfrog.artifactory+json";
    private static final String SEND_MODULE_INFO_ENDPOINT = "/api/build/append/";
    private final Build build;

    public SendModuleInfo(Build build, Log logger) {
        super(logger);
        this.build = build;
    }

    @Override
    public HttpRequestBase createRequest() throws IOException {
        String url = SEND_MODULE_INFO_ENDPOINT + SendModuleInfo.encodeUrl(this.build.getName()) + "/" + SendModuleInfo.encodeUrl(this.build.getNumber()) + PublishBuildInfo.getProjectQueryParam(this.build.getProject());
        HttpPost request = new HttpPost(url);
        String modulesAsJsonString = JsonUtils.toJsonString(this.build.getModules());
        StringEntity stringEntity = new StringEntity(modulesAsJsonString, "UTF-8");
        stringEntity.setContentType(APPLICATION_VND_ORG_JFROG_ARTIFACTORY_JSON);
        request.setEntity(stringEntity);
        this.log.info("Deploying build descriptor to: " + request.getURI().toString());
        return request;
    }

    @Override
    protected void handleUnsuccessfulResponse(HttpEntity entity) throws IOException {
        this.log.error("Could not publish build-info modules");
        SendModuleInfo.throwException(entity, this.getStatusCode());
    }
}

