/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.clientConfiguration.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.jfrog.build.api.search.AqlSearchResult;
import org.jfrog.build.api.util.Log;
import org.jfrog.build.extractor.clientConfiguration.client.artifactory.ArtifactoryManager;
import org.jfrog.build.extractor.clientConfiguration.util.spec.FileSpec;

public class AqlHelperBase {
    protected static final String LATEST = "LATEST";
    protected static final String LAST_RELEASE = "LAST_RELEASE";
    protected static final String DELIMITER = "/";
    protected static final String ESCAPE_CHAR = "\\";
    protected ArtifactoryManager artifactoryManager;
    private Log log;
    protected String queryBody;
    protected String includeFields;
    protected String querySuffix;
    protected String buildName;
    protected String buildNumber;

    AqlHelperBase(ArtifactoryManager artifactoryManager, Log log, FileSpec file) throws IOException {
        this.artifactoryManager = artifactoryManager;
        this.log = log;
        this.convertFileSpecToAql(file);
    }

    protected void buildQueryAdditionalParts(FileSpec file) throws IOException {
        this.buildName = AqlHelperBase.getBuildName(file.getBuild());
        this.buildNumber = this.getBuildNumber(this.artifactoryManager, this.buildName, file.getBuild(), null);
        this.querySuffix = AqlHelperBase.buildQuerySuffix(file.getSortBy(), file.getSortOrder(), file.getOffset(), file.getLimit());
        this.includeFields = AqlHelperBase.buildIncludeQueryPart(file.getSortBy(), this.querySuffix);
    }

    protected void convertFileSpecToAql(FileSpec file) throws IOException {
        this.buildQueryAdditionalParts(file);
        this.queryBody = file.getAql();
    }

    public List<AqlSearchResult.SearchEntry> run() throws IOException {
        String aql = "items.find(" + this.queryBody + ")" + this.includeFields + this.querySuffix;
        this.log.debug("Searching Artifactory using AQL query:\n" + aql);
        AqlSearchResult aqlSearchResult = this.artifactoryManager.searchArtifactsByAql(aql);
        List<AqlSearchResult.SearchEntry> queryResults = aqlSearchResult.getResults();
        ArrayList results = this.filterResult(queryResults);
        return results == null ? new ArrayList() : results;
    }

    protected static String getBuildName(String build) {
        if (StringUtils.isBlank(build)) {
            return build;
        }
        String buildName = StringUtils.substringBeforeLast(build, DELIMITER);
        while (StringUtils.isNotBlank(buildName) && buildName.contains(DELIMITER) && buildName.endsWith(ESCAPE_CHAR)) {
            buildName = StringUtils.substringBeforeLast(buildName, DELIMITER);
        }
        return buildName.endsWith(ESCAPE_CHAR) ? build : buildName;
    }

    protected String getBuildNumber(ArtifactoryManager client, String buildName, String build, String project) throws IOException {
        String buildNumber = "";
        if (StringUtils.isNotBlank(buildName)) {
            if (!build.startsWith(buildName)) {
                throw new IllegalStateException(String.format("build '%s' does not start with build name '%s'.", build, buildName));
            }
            if (build.equals(buildName)) {
                buildNumber = LATEST;
            } else {
                buildNumber = build.substring(buildName.length() + DELIMITER.length());
                buildNumber = buildNumber.replace("\\/", DELIMITER);
            }
            String retrievedBuildNumber = client.getLatestBuildNumber(buildName, buildNumber, project);
            if (retrievedBuildNumber == null) {
                this.logBuildNotFound(buildName, buildNumber);
            }
            buildNumber = retrievedBuildNumber;
        }
        return buildNumber;
    }

    private void logBuildNotFound(String buildName, String buildNumber) {
        StringBuilder sb = new StringBuilder("The build name ").append(buildName);
        if (LAST_RELEASE.equals(buildNumber.trim())) {
            sb.append(" with the status RELEASED");
        }
        sb.append(" could not be found.");
        this.log.warn(sb.toString());
    }

    protected static String buildIncludeQueryPart(String[] sortByFields, String suffix) {
        List<String> fieldsToInclude = AqlHelperBase.getQueryReturnFields(sortByFields);
        if (StringUtils.isBlank(suffix)) {
            fieldsToInclude.add("property");
        }
        return ".include(" + StringUtils.join(AqlHelperBase.prepareFieldsForQuery(fieldsToInclude), ',') + ")";
    }

    private static List<String> getQueryReturnFields(String[] sortByFields) {
        ArrayList<String> includeFields = new ArrayList<String>(Arrays.asList("name", "repo", "path", "actual_md5", "actual_sha1", "size", "type"));
        for (String field : sortByFields) {
            if (includeFields.indexOf(field) != -1) continue;
            includeFields.add(field);
        }
        return includeFields;
    }

    private static List<String> prepareFieldsForQuery(List<String> fields) {
        fields.forEach(field -> fields.set(fields.indexOf(field), '\"' + field + '\"'));
        return fields;
    }

    protected static String buildQuerySuffix(String[] sortBy, String sortOrder, String offset, String limit) {
        StringBuilder query = new StringBuilder();
        if (sortBy != ArrayUtils.EMPTY_STRING_ARRAY) {
            sortOrder = StringUtils.defaultIfEmpty(sortOrder, "asc");
            query.append(".sort({\"$").append(sortOrder).append("\":");
            query.append("[").append(AqlHelperBase.prepareSortFieldsForQuery(sortBy)).append("]})");
        }
        if (StringUtils.isNotBlank(offset)) {
            query.append(".offset(").append(offset).append(")");
        }
        if (StringUtils.isNotBlank(limit)) {
            query.append(".limit(").append(limit).append(")");
        }
        return query.toString();
    }

    private static String prepareSortFieldsForQuery(String[] sortByFields) {
        StringBuilder fields = new StringBuilder();
        int size = sortByFields.length;
        for (int i = 0; i < size; ++i) {
            fields.append("\"").append(sortByFields[i]).append("\"");
            if (i >= size - 1) continue;
            fields.append(",");
        }
        return fields.toString();
    }

    protected static List<AqlSearchResult.SearchEntry> filterAqlSearchResultsByBuild(List<AqlSearchResult.SearchEntry> itemsToFilter, Map<String, Boolean> buildArtifactsSha1, String buildName, String buildNumber) {
        HashMap<String, List<AqlSearchResult.SearchEntry>> firstPriority = new HashMap<String, List<AqlSearchResult.SearchEntry>>();
        HashMap<String, List<AqlSearchResult.SearchEntry>> secondPriority = new HashMap<String, List<AqlSearchResult.SearchEntry>>();
        HashMap<String, List<AqlSearchResult.SearchEntry>> thirdPriority = new HashMap<String, List<AqlSearchResult.SearchEntry>>();
        ArrayList<AqlSearchResult.SearchEntry> filteredResults = new ArrayList<AqlSearchResult.SearchEntry>();
        for (AqlSearchResult.SearchEntry searchEntry : itemsToFilter) {
            if (!buildArtifactsSha1.containsKey(searchEntry.getActualSha1())) continue;
            boolean isBuildNameMatch = buildName.equals(searchEntry.getBuildName());
            boolean isBuildNumberMatch = buildNumber.equals(searchEntry.getBuildNumber());
            if (isBuildNameMatch) {
                if (isBuildNumberMatch) {
                    AqlHelperBase.addToListInMap(firstPriority, searchEntry);
                    continue;
                }
                AqlHelperBase.addToListInMap(secondPriority, searchEntry);
                continue;
            }
            AqlHelperBase.addToListInMap(thirdPriority, searchEntry);
        }
        for (Map.Entry entry : buildArtifactsSha1.entrySet()) {
            String shaToMatch = (String)entry.getKey();
            if (firstPriority.containsKey(shaToMatch)) {
                filteredResults.addAll((Collection)firstPriority.get(shaToMatch));
                continue;
            }
            if (secondPriority.containsKey(shaToMatch)) {
                filteredResults.addAll((Collection)secondPriority.get(shaToMatch));
                continue;
            }
            if (!thirdPriority.containsKey(shaToMatch)) continue;
            filteredResults.addAll((Collection)thirdPriority.get(shaToMatch));
        }
        return filteredResults;
    }

    private static void addToListInMap(Map<String, List<AqlSearchResult.SearchEntry>> map, AqlSearchResult.SearchEntry item) {
        List<AqlSearchResult.SearchEntry> curList = map.get(item.getActualSha1());
        if (curList == null) {
            curList = new ArrayList<AqlSearchResult.SearchEntry>();
        }
        curList.add(item);
        map.put(item.getActualSha1(), curList);
    }

    protected static Map<String, Boolean> extractSha1FromAqlResponse(List<AqlSearchResult.SearchEntry> searchResults) {
        HashMap<String, Boolean> resultsMap = new HashMap<String, Boolean>();
        searchResults.forEach(result -> resultsMap.put(result.getActualSha1(), true));
        return resultsMap;
    }

    protected static String createAqlBodyForBuild(String buildName, String buildNumber) {
        return String.format("{\"artifact.module.build.name\": \"%s\",\"artifact.module.build.number\": \"%s\"}", buildName, buildNumber);
    }

    protected List<AqlSearchResult.SearchEntry> filterResult(List<AqlSearchResult.SearchEntry> queryResults) throws IOException {
        if (StringUtils.isNotBlank(this.buildName) && queryResults.size() > 0) {
            Map<String, Boolean> buildArtifactsSha1 = this.fetchBuildArtifactsSha1();
            queryResults = AqlHelperBase.filterAqlSearchResultsByBuild(queryResults, buildArtifactsSha1, this.buildName, this.buildNumber);
        }
        return queryResults;
    }

    private Map<String, Boolean> fetchBuildArtifactsSha1() throws IOException {
        String includeSha1Field = ".include(\"name\",\"repo\",\"path\",\"actual_sha1\")";
        String buildAql = this.createAqlQueryForBuild(includeSha1Field);
        this.log.debug("Searching Artifactory for build's checksums using AQL query:\n" + buildAql);
        AqlSearchResult aqlSearchResult = this.artifactoryManager.searchArtifactsByAql(buildAql);
        return AqlHelperBase.extractSha1FromAqlResponse(aqlSearchResult.getResults());
    }

    private String createAqlQueryForBuild(String includeQueryPart) {
        return String.format("items.find(%s)%s", AqlHelperBase.createAqlBodyForBuild(this.buildName, this.buildNumber), includeQueryPart);
    }
}

