/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.extractor.scan;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;

public class GeneralInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String componentId = "";
    private String name = "";
    private String path = "";
    private String pkgType = "";
    private String groupId = "";
    private String artifactId = "";
    private String version = "";
    private String sha1 = "";

    public GeneralInfo() {
    }

    public GeneralInfo(String componentId, String name, String path, String pkgType) {
        this.componentId = componentId;
        this.name = name;
        this.path = path;
        this.pkgType = pkgType;
    }

    public String getGroupId() {
        if (StringUtils.isNotBlank(this.groupId)) {
            return this.groupId;
        }
        return this.isValid() ? this.componentId.substring(0, this.componentId.indexOf(":")) : "";
    }

    public String getArtifactId() {
        if (StringUtils.isNotBlank(this.artifactId)) {
            return this.artifactId;
        }
        if (!this.isValid()) {
            return "";
        }
        int indexOfColon = this.componentId.indexOf(":");
        if (StringUtils.countMatches(this.componentId, ":") == 1) {
            return this.componentId.substring(0, indexOfColon);
        }
        return this.componentId.substring(indexOfColon + 1, this.componentId.lastIndexOf(":"));
    }

    public String getVersion() {
        if (StringUtils.isNotBlank(this.version)) {
            return this.version;
        }
        return this.isValid() ? this.componentId.substring(this.componentId.lastIndexOf(":") + 1) : "";
    }

    public String getComponentId() {
        return this.componentId;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getPkgType() {
        return this.pkgType;
    }

    public String getSha1() {
        return this.sha1;
    }

    public GeneralInfo componentId(String componentId) {
        this.componentId = componentId;
        return this;
    }

    public GeneralInfo name(String name) {
        this.name = name;
        return this;
    }

    public GeneralInfo path(String path) {
        this.path = path;
        return this;
    }

    public GeneralInfo groupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public GeneralInfo artifactId(String artifactId) {
        this.artifactId = artifactId;
        return this;
    }

    public GeneralInfo version(String version) {
        this.version = version;
        return this;
    }

    public GeneralInfo pkgType(String pkgType) {
        this.pkgType = pkgType;
        return this;
    }

    public GeneralInfo sha1(String sha1) {
        this.sha1 = sha1;
        return this;
    }

    private boolean isValid() {
        int colonCount = StringUtils.countMatches(this.componentId, ":");
        return colonCount == 1 || colonCount == 2;
    }
}

